/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.capability.SuperAdminInstance;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.NetworkUpdatePacket;

public class FluxNetworkData
extends WorldSavedData {
    private static final String NETWORK_DATA = "fluxnetworksdata";
    private static FluxNetworkData data;
    public static String NETWORKS;
    public static String LOADED_CHUNKS;
    public static String UNIQUE_ID;
    public static String NETWORK_ID;
    public static String NETWORK_NAME;
    public static String NETWORK_COLOR;
    public static String NETWORK_PASSWORD;
    public static String SECURITY_TYPE;
    public static String ENERGY_TYPE;
    public static String OWNER_UUID;
    public static String WIRELESS_MODE;
    public static String PLAYER_LIST;
    public static String NETWORK_FOLDERS;
    public static String UNLOADED_CONNECTIONS;
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public Map<Integer, List<ChunkPos>> loadedChunks = new HashMap<Integer, List<ChunkPos>>();
    public int uniqueID = 1;

    public FluxNetworkData() {
        super(NETWORK_DATA);
    }

    public static FluxNetworkData get() {
        if (data == null) {
            FluxNetworkData.load();
        }
        return data;
    }

    private static void load() {
        ServerWorld saveWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_);
        data = (FluxNetworkData)saveWorld.func_217481_x().func_215752_a(FluxNetworkData::new, NETWORK_DATA);
        FluxNetworks.LOGGER.info("FluxNetworkData has been successfully loaded");
    }

    public static void release() {
        if (data != null) {
            data = null;
            FluxNetworks.LOGGER.info("FluxNetworkData has been unloaded");
        }
    }

    public void addNetwork(IFluxNetwork network) {
        this.networks.putIfAbsent(network.getNetworkID(), network);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
    }

    public void deleteNetwork(IFluxNetwork network) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new NetworkUpdatePacket(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_CLEAR));
        network.onDeleted();
        this.networks.remove(network.getNetworkID());
    }

    public boolean func_76188_b() {
        return true;
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        this.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        if (nbt.func_74764_b(NETWORKS)) {
            ListNBT list = nbt.func_150295_c(NETWORKS, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                FluxNetworkServer network = new FluxNetworkServer();
                network.readNetworkNBT(tag, NBTType.ALL_SAVE);
                this.addNetwork(network);
            }
        }
        this.readChunks(nbt);
        data = this;
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a(UNIQUE_ID, this.uniqueID);
        ListNBT list = new ListNBT();
        for (IFluxNetwork network : this.networks.values()) {
            CompoundNBT tag = new CompoundNBT();
            network.writeNetworkNBT(tag, NBTType.ALL_SAVE);
            list.add((Object)tag);
        }
        compound.func_218657_a(NETWORKS, (INBT)list);
        CompoundNBT tag = new CompoundNBT();
        this.loadedChunks.forEach((dim, pos) -> this.writeChunks((int)dim, (List<ChunkPos>)pos, tag));
        compound.func_218657_a(LOADED_CHUNKS, (INBT)tag);
        return compound;
    }

    public static void readPlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(PLAYER_LIST)) {
            return;
        }
        ArrayList<NetworkMember> a = new ArrayList<NetworkMember>();
        ListNBT list = nbt.func_150295_c(PLAYER_LIST, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT c = list.func_150305_b(i);
            a.add(new NetworkMember(c));
        }
        network.setSetting(NetworkSettings.NETWORK_PLAYERS, a);
    }

    public static void writePlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> list.add((Object)s.writeNetworkNBT(new CompoundNBT())));
            nbt.func_218657_a(PLAYER_LIST, (INBT)list);
        }
    }

    public static void writeAllPlayers(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List players;
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        ListNBT list = new ListNBT();
        if (!a.isEmpty()) {
            a.forEach(s -> list.add((Object)s.writeNetworkNBT(new CompoundNBT())));
        }
        if (!(players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()).isEmpty()) {
            players.stream().filter(p -> a.stream().noneMatch(s -> s.getPlayerUUID().equals(p.func_110124_au()))).forEach(s -> list.add((Object)NetworkMember.createNetworkMember((PlayerEntity)s, FluxNetworkData.getPermission((PlayerEntity)s)).writeNetworkNBT(new CompoundNBT())));
        }
        nbt.func_218657_a(PLAYER_LIST, (INBT)list);
    }

    private static EnumAccessType getPermission(@Nonnull PlayerEntity player) {
        return SuperAdminInstance.isPlayerSuperAdmin(player) ? EnumAccessType.SUPER_ADMIN : EnumAccessType.NONE;
    }

    public static void readConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        ListNBT list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.size(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.getSetting(NetworkSettings.ALL_CONNECTORS).addAll(a);
    }

    public static void writeConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> {
                if (!s.isChunkLoaded()) {
                    list.add((Object)s.writeCustomNBT(new CompoundNBT(), NBTType.DEFAULT));
                }
            });
            nbt.func_218657_a(UNLOADED_CONNECTIONS, (INBT)list);
        }
    }

    public static void readAllConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        ListNBT list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.size(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.setSetting(NetworkSettings.ALL_CONNECTORS, a);
    }

    public static void writeAllConnections(IFluxNetwork network, @Nonnull CompoundNBT nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            ListNBT list = new ListNBT();
            a.forEach(s -> list.add((Object)s.writeCustomNBT(new CompoundNBT(), NBTType.DEFAULT)));
            nbt.func_218657_a(UNLOADED_CONNECTIONS, (INBT)list);
        }
    }

    private void readChunks(CompoundNBT nbt) {
        if (!nbt.func_74764_b(LOADED_CHUNKS)) {
            return;
        }
        CompoundNBT tags = nbt.func_74775_l(LOADED_CHUNKS);
        for (String key : tags.func_150296_c()) {
            ListNBT list = tags.func_150295_c(key, 10);
            List pos = this.loadedChunks.computeIfAbsent(Integer.valueOf(key), l -> new ArrayList());
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                pos.add(new ChunkPos(tag.func_74762_e("x"), tag.func_74762_e("z")));
            }
        }
    }

    private void writeChunks(int dim, List<ChunkPos> pos, CompoundNBT nbt) {
        if (!pos.isEmpty()) {
            ListNBT list = new ListNBT();
            pos.forEach(p -> {
                CompoundNBT t = new CompoundNBT();
                t.func_74768_a("x", p.field_77276_a);
                t.func_74768_a("z", p.field_77275_b);
                list.add((Object)t);
            });
            nbt.func_218657_a(String.valueOf(dim), (INBT)list);
        }
    }

    static {
        NETWORKS = "networks";
        LOADED_CHUNKS = "loadedChunks";
        UNIQUE_ID = "uniqueID";
        NETWORK_ID = "networkID";
        NETWORK_NAME = "networkName";
        NETWORK_COLOR = "networkColor";
        NETWORK_PASSWORD = "networkPassword";
        SECURITY_TYPE = "networkSecurity";
        ENERGY_TYPE = "networkEnergy";
        OWNER_UUID = "ownerUUID";
        WIRELESS_MODE = "wirelessMode";
        PLAYER_LIST = "playerList";
        NETWORK_FOLDERS = "folders";
        UNLOADED_CONNECTIONS = "unloaded";
    }
}

