/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.handler.energy;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.energy.IItemEnergyHandler;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;

public class ForgeEnergyHandler
implements ITileEnergyHandler,
IItemEnergyHandler {
    public static final ForgeEnergyHandler INSTANCE = new ForgeEnergyHandler();

    @Override
    public boolean canRenderConnection(@Nonnull TileEntity tile, Direction side) {
        return !tile.func_145837_r() && tile.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    @Override
    public boolean canAddEnergy(TileEntity tile, Direction side) {
        if (this.canRenderConnection(tile, side)) {
            IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
            return storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(TileEntity tile, Direction side) {
        if (this.canRenderConnection(tile, side)) {
            IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
            return storage.canExtract();
        }
        return false;
    }

    @Override
    public long addEnergy(long amount, TileEntity tile, Direction side, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
        return storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long removeEnergy(long amount, TileEntity tile, Direction side) {
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side).orElse(null);
        return storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), false);
    }

    @Override
    public boolean canAddEnergy(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null) {
            return storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null) {
            return storage.canExtract();
        }
        return false;
    }

    @Override
    public long addEnergy(long amount, ItemStack stack, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long removeEnergy(long amount, ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        return storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), false);
    }
}

