/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.FluxCacheType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxChunkManager;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.FluxConnectorBlockItem;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.FeedbackPacket;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class BatchEditingPacket
extends AbstractPacket {
    public int networkID;
    public List<Coord4D> coord4DS = new ArrayList<Coord4D>();
    public CompoundNBT tag;
    public boolean[] editions = new boolean[7];

    public BatchEditingPacket(PacketBuffer buf) {
        this.networkID = buf.readInt();
        for (int i = 0; i < 7; ++i) {
            this.editions[i] = buf.readBoolean();
        }
        this.tag = buf.func_150793_b();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.coord4DS.add(new Coord4D((ByteBuf)buf));
        }
    }

    public BatchEditingPacket(int networkID, List<Coord4D> coord4DS, CompoundNBT tag, boolean[] editions) {
        this.networkID = networkID;
        this.coord4DS = coord4DS;
        this.tag = tag;
        this.editions = editions;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.networkID);
        boolean[] blArray = this.editions;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean b = blArray[i];
            buf.writeBoolean(b.booleanValue());
        }
        buf.func_150786_a(this.tag);
        buf.writeInt(this.coord4DS.size());
        this.coord4DS.forEach(c -> c.write((ByteBuf)buf));
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        IFluxNetwork network;
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        if (player != null && !(network = FluxNetworkCache.INSTANCE.getNetwork(this.networkID)).isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                boolean editName = this.editions[0];
                boolean editPriority = this.editions[1];
                boolean editLimit = this.editions[2];
                boolean editSurge = this.editions[3];
                boolean editUnlimited = this.editions[4];
                boolean editChunkLoad = this.editions[5];
                boolean disconnect = this.editions[6];
                String name = this.tag.func_74779_i(FluxConnectorBlockItem.CUSTOM_NAME);
                int priority = this.tag.func_74762_e(FluxConnectorBlockItem.PRIORITY);
                long limit = this.tag.func_74763_f(FluxConnectorBlockItem.LIMIT);
                boolean surge = this.tag.func_74767_n(FluxConnectorBlockItem.SURGE_MODE);
                boolean unlimited = this.tag.func_74767_n(FluxConnectorBlockItem.DISABLE_LIMIT);
                boolean load = this.tag.func_74767_n("chunkLoad");
                ArrayList onlineConnectors = new ArrayList();
                network.getConnections(FluxCacheType.FLUX).forEach(e -> onlineConnectors.add((TileFluxCore)e));
                AtomicBoolean reject = new AtomicBoolean(false);
                for (Coord4D c : this.coord4DS) {
                    onlineConnectors.stream().filter(f -> f.getCoords().equals(c)).findFirst().ifPresent(f -> {
                        if (disconnect) {
                            FluxUtils.removeConnection(f, false);
                            f.disconnect(network);
                        } else {
                            if (editName) {
                                f.customName = name;
                            }
                            if (editPriority) {
                                f.priority = priority;
                            }
                            if (editLimit) {
                                f.limit = Math.min(limit, f.getMaxTransferLimit());
                            }
                            if (editSurge) {
                                f.surgeMode = surge;
                            }
                            if (editUnlimited) {
                                f.disableLimit = unlimited;
                            }
                            if (editChunkLoad) {
                                if (FluxConfig.enableChunkLoading) {
                                    if (load) {
                                        if (f.getConnectionType().isStorage()) {
                                            reject.set(true);
                                            return;
                                        }
                                        if (!f.chunkLoading) {
                                            f.chunkLoading = FluxChunkManager.addChunkLoader((ServerWorld)f.getFluxWorld(), new ChunkPos(f.func_174877_v()));
                                            if (!f.chunkLoading) {
                                                reject.set(true);
                                            }
                                        }
                                    } else {
                                        FluxChunkManager.removeChunkLoader((ServerWorld)f.getFluxWorld(), new ChunkPos(f.func_174877_v()));
                                        f.chunkLoading = false;
                                    }
                                } else {
                                    f.chunkLoading = false;
                                }
                            }
                            f.sendFullUpdatePacket();
                        }
                    });
                }
                if (reject.get()) {
                    this.reply(ctx, (Object)new FeedbackPacket(EnumFeedbackInfo.REJECT_SOME));
                }
                return disconnect ? new FeedbackPacket(EnumFeedbackInfo.SUCCESS_2) : new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
            }
            return new FeedbackPacket(EnumFeedbackInfo.NO_ADMIN);
        }
        return null;
    }
}

