/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.utils.FluxConfigurationType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.FluxConfiguratorItem;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.FeedbackPacket;

public class ConfiguratorNetworkConnectPacket
extends AbstractPacket {
    public int id;
    public String password;

    public ConfiguratorNetworkConnectPacket(int id, String password) {
        this.id = id;
        this.password = password;
    }

    public ConfiguratorNetworkConnectPacket(PacketBuffer buf) {
        this.id = buf.readInt();
        this.password = buf.func_150789_c(256);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.id);
        buf.func_211400_a(this.password, 256);
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(this.id);
        if (!network.isInvalid()) {
            ItemStack stack;
            if (!network.getMemberPermission(player).canAccess()) {
                if (this.password.isEmpty()) {
                    return new FeedbackPacket(EnumFeedbackInfo.PASSWORD_REQUIRE);
                }
                if (!this.password.equals(network.getSetting(NetworkSettings.NETWORK_PASSWORD))) {
                    return new FeedbackPacket(EnumFeedbackInfo.REJECT);
                }
            }
            if ((stack = player.func_184614_ca()).func_77973_b() instanceof FluxConfiguratorItem) {
                CompoundNBT configs = stack.func_190925_c("Configs");
                configs.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), this.id);
            }
            return new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
        }
        return null;
    }
}

