/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.network.FluxCacheType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.common.connection.FluxLiteConnector;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.ConnectionUpdatePacket;

public class ConnectionUpdateRequestPacket
extends AbstractPacket {
    public int networkID;
    public List<Coord4D> coords = new ArrayList<Coord4D>();

    public ConnectionUpdateRequestPacket(PacketBuffer buf) {
        this.networkID = buf.readInt();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.coords.add(new Coord4D((ByteBuf)buf));
        }
    }

    public ConnectionUpdateRequestPacket(int networkID, List<Coord4D> coords) {
        this.networkID = networkID;
        this.coords = coords;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.networkID);
        buf.writeInt(this.coords.size());
        this.coords.forEach(c -> c.write((ByteBuf)buf));
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        if (this.coords.isEmpty()) {
            return null;
        }
        IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(this.networkID);
        if (!network.isInvalid()) {
            PlayerEntity player = PacketHandler.getPlayer(ctx);
            ArrayList<CompoundNBT> tags = new ArrayList<CompoundNBT>();
            List<IFluxConnector> onlineConnectors = network.getConnections(FluxCacheType.FLUX);
            this.coords.forEach(c -> onlineConnectors.stream().filter(f -> f.getCoords().equals(c)).findFirst().ifPresent(f -> tags.add(FluxLiteConnector.writeCustomNBT(f, new CompoundNBT()))));
            return new ConnectionUpdatePacket(this.networkID, tags);
        }
        return null;
    }
}

