/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.GUIPermissionPacket;

public class GUIPermissionRequestPacket
extends AbstractPacket {
    public int networkID;
    public UUID uuid;

    public GUIPermissionRequestPacket(PacketBuffer buf) {
        this.networkID = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
    }

    public GUIPermissionRequestPacket(int networkID, UUID uuid) {
        this.networkID = networkID;
        this.uuid = uuid;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.networkID);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(this.networkID);
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(this.uuid);
        EnumAccessType accessType = network.isInvalid() || player == null ? EnumAccessType.NONE : network.getMemberPermission((PlayerEntity)player);
        return new GUIPermissionPacket(accessType);
    }
}

