/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.NetworkColourPacket;

public class NetworkColourRequestPacket
extends AbstractPacket {
    List<Integer> requests;

    public NetworkColourRequestPacket(List<Integer> requests) {
        this.requests = requests;
    }

    public NetworkColourRequestPacket(PacketBuffer buf) {
        this.requests = new ArrayList<Integer>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.requests.add(buf.readInt());
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.requests.size());
        this.requests.forEach(arg_0 -> ((PacketBuffer)buf).writeInt(arg_0));
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        PlayerEntity player = PacketHandler.getPlayer(ctx);
        HashMap<Integer, Tuple<Integer, String>> cache = new HashMap<Integer, Tuple<Integer, String>>();
        if (!this.requests.isEmpty()) {
            for (int id : this.requests) {
                IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(id);
                cache.put(id, (Tuple<Integer, String>)new Tuple((Object)(network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000), (Object)(network.isInvalid() ? "NONE" : network.getSetting(NetworkSettings.NETWORK_NAME))));
            }
            this.reply(player, (Object)new NetworkColourPacket(cache));
        }
        return null;
    }
}

