/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.AbstractPacket;
import sonar.fluxnetworks.common.network.NetworkUpdatePacket;

public class NetworkUpdateRequestPacket
extends AbstractPacket {
    public List<Integer> networkIDs = Lists.newArrayList();
    public NBTType type;

    public NetworkUpdateRequestPacket(int networkID, NBTType type) {
        this.networkIDs.add(networkID);
        this.type = type;
    }

    public NetworkUpdateRequestPacket(List<IFluxNetwork> networks, NBTType type) {
        networks.forEach(n -> this.networkIDs.add(n.getNetworkID()));
        this.type = type;
    }

    public NetworkUpdateRequestPacket(PacketBuffer buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.networkIDs.add(buf.readInt());
        }
        this.type = NBTType.values()[buf.readInt()];
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.networkIDs.size());
        this.networkIDs.forEach(arg_0 -> ((PacketBuffer)buf).writeInt(arg_0));
        buf.writeInt(this.type.ordinal());
    }

    @Override
    public Object handle(NetworkEvent.Context ctx) {
        ArrayList networks = Lists.newArrayList();
        for (Integer i : this.networkIDs) {
            IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(i);
            if (network.isInvalid()) continue;
            networks.add(network);
        }
        if (!networks.isEmpty()) {
            return new NetworkUpdatePacket(Lists.newArrayList((Iterable)networks), this.type);
        }
        return null;
    }
}

