/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.FluxCacheType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.data.FluxChunkManager;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.network.FeedbackPacket;
import sonar.fluxnetworks.common.tileentity.TileFluxCore;

public class TilePacketHandler {
    public static CompoundNBT getSetNetworkPacket(int id, String password) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, id);
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static Object handleSetNetworkPacket(TileFluxCore tile, PlayerEntity player, CompoundNBT tag) {
        int id = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String pass = tag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (tile.getNetworkID() == id) {
            return null;
        }
        IFluxNetwork network = FluxNetworkCache.INSTANCE.getNetwork(id);
        if (!network.isInvalid()) {
            if (tile.getConnectionType().isController() && network.getConnections(FluxCacheType.CONTROLLER).size() > 0) {
                return new FeedbackPacket(EnumFeedbackInfo.HAS_CONTROLLER);
            }
            if (!network.getMemberPermission(player).canAccess()) {
                if (pass.isEmpty()) {
                    return new FeedbackPacket(EnumFeedbackInfo.PASSWORD_REQUIRE);
                }
                if (!pass.equals(network.getSetting(NetworkSettings.NETWORK_PASSWORD))) {
                    return new FeedbackPacket(EnumFeedbackInfo.REJECT);
                }
            }
            if (tile.getNetwork() != null && !tile.getNetwork().isInvalid()) {
                tile.getNetwork().queueConnectionRemoval(tile, false);
            }
            tile.playerUUID = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
            network.queueConnectionAddition(tile);
            return new FeedbackPacket(EnumFeedbackInfo.SUCCESS);
        }
        return null;
    }

    public static CompoundNBT getChunkLoadPacket(boolean chunkLoading) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("c", chunkLoading);
        return tag;
    }

    public static Object handleChunkLoadPacket(TileFluxCore tile, PlayerEntity player, CompoundNBT tag) {
        boolean load = tag.func_74767_n("c");
        if (FluxConfig.enableChunkLoading) {
            if (load) {
                boolean p;
                tile.chunkLoading = p = FluxChunkManager.addChunkLoader((ServerWorld)tile.getFluxWorld(), new ChunkPos(tile.func_174877_v()));
                tile.settings_changed = true;
                if (!p) {
                    return new FeedbackPacket(EnumFeedbackInfo.HAS_LOADER);
                }
            } else {
                FluxChunkManager.removeChunkLoader((ServerWorld)tile.getFluxWorld(), new ChunkPos(tile.func_174877_v()));
                tile.chunkLoading = false;
                tile.settings_changed = true;
            }
            return null;
        }
        tile.chunkLoading = false;
        tile.settings_changed = true;
        return new FeedbackPacket(EnumFeedbackInfo.BANNED_LOADING);
    }
}

