/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConfigurable;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.tiles.ITilePacketBuffer;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.connection.handler.AbstractTransferHandler;
import sonar.fluxnetworks.common.core.ContainerConnector;
import sonar.fluxnetworks.common.core.FluxUtils;
import sonar.fluxnetworks.common.data.FluxChunkManager;
import sonar.fluxnetworks.common.data.FluxNetworkData;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.item.FluxConnectorBlockItem;
import sonar.fluxnetworks.common.network.TilePacketBufferPacket;

public abstract class TileFluxCore
extends TileEntity
implements IFluxConnector,
IFluxConfigurable,
ITickableTileEntity,
ITilePacketBuffer,
INamedContainerProvider {
    public HashSet<PlayerEntity> playerUsing = new HashSet();
    public String customName = "";
    public int networkID = -1;
    public UUID playerUUID = FluxUtils.UUID_DEFAULT;
    public int color = -1;
    public int folderID = -1;
    public int priority = 0;
    public long limit = FluxConfig.defaultLimit;
    public boolean surgeMode = false;
    public boolean disableLimit = false;
    public boolean connected = false;
    public byte[] connections = new byte[]{0, 0, 0, 0, 0, 0};
    public boolean chunkLoading = false;
    protected IFluxNetwork network = FluxNetworkInvalid.INSTANCE;
    protected boolean load = false;
    public boolean settings_changed;
    public Coord4D coord4D;

    public TileFluxCore(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.load) {
            FluxUtils.removeConnection(this, false);
            if (this.chunkLoading) {
                FluxChunkManager.removeChunkLoader((ServerWorld)this.field_145850_b, new ChunkPos(this.field_174879_c));
            }
            this.load = false;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.field_145850_b.field_72995_K && this.load) {
            FluxUtils.removeConnection(this, true);
            this.load = false;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.playerUsing.size() > 0) {
                this.sendTilePacketToUsing((byte)5);
                this.settings_changed = false;
            }
            if (!this.load) {
                if (!FluxUtils.addConnection(this)) {
                    this.networkID = -1;
                    this.connected = false;
                    this.color = 0xB2B2B2;
                }
                this.updateTransfers(Direction.values());
                this.sendFullUpdatePacket();
                this.load = true;
            }
        }
    }

    @Override
    public void connect(@Nonnull IFluxNetwork network) {
        this.network = network;
        this.networkID = network.getNetworkID();
        this.color = network.getSetting(NetworkSettings.NETWORK_COLOR);
        this.connected = true;
        this.sendFullUpdatePacket();
    }

    @Override
    public void disconnect(@Nonnull IFluxNetwork network) {
        if (network.getNetworkID() == this.getNetworkID()) {
            this.network = FluxNetworkInvalid.INSTANCE;
            this.networkID = -1;
            this.color = 0xB2B2B2;
            this.connected = false;
            this.sendFullUpdatePacket();
        }
    }

    @Override
    public IFluxNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.writeCustomNBT(new CompoundNBT(), NBTType.TILE_UPDATE));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readCustomNBT(pkt.func_148857_g(), NBTType.TILE_UPDATE);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    @Override
    public World getFluxWorld() {
        return this.field_145850_b;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeCustomNBT(compound, NBTType.ALL_SAVE);
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound, NBTType.ALL_SAVE);
    }

    @Override
    public CompoundNBT writeCustomNBT(CompoundNBT tag, NBTType type) {
        if (type == NBTType.ALL_SAVE || type == NBTType.TILE_UPDATE) {
            tag.func_74768_a("0", this.priority);
            tag.func_74772_a("1", this.limit);
            tag.func_74757_a("2", this.disableLimit);
            tag.func_74757_a("3", this.surgeMode);
            tag.func_74768_a("4", this.networkID);
            tag.func_186854_a("5", this.playerUUID);
            tag.func_74778_a("6", this.customName);
            tag.func_74768_a("7", this.color);
            tag.func_74757_a("8", this.connected);
            tag.func_74768_a("9", this.folderID);
            for (int i = 0; i < this.connections.length; ++i) {
                tag.func_74774_a('c' + String.valueOf(i), this.connections[i]);
            }
            tag.func_74772_a("buf", this.getTransferHandler().getBuffer());
            tag.func_74757_a("l", this.chunkLoading);
        }
        if (type == NBTType.TILE_UPDATE) {
            this.getTransferHandler().writeNetworkedNBT(tag);
        }
        if (type == NBTType.TILE_DROP) {
            tag.func_74772_a("buffer", this.getTransferHandler().getBuffer());
            tag.func_74768_a(FluxConnectorBlockItem.PRIORITY, this.priority);
            tag.func_74772_a(FluxConnectorBlockItem.LIMIT, this.limit);
            tag.func_74757_a(FluxConnectorBlockItem.DISABLE_LIMIT, this.disableLimit);
            tag.func_74757_a(FluxConnectorBlockItem.SURGE_MODE, this.surgeMode);
            tag.func_74768_a(FluxNetworkData.NETWORK_ID, this.networkID);
            tag.func_74778_a(FluxConnectorBlockItem.CUSTOM_NAME, this.customName);
            tag.func_74768_a("folderID", this.folderID);
        }
        return tag;
    }

    @Override
    public void readCustomNBT(CompoundNBT tag, NBTType type) {
        if (type == NBTType.ALL_SAVE || type == NBTType.TILE_UPDATE) {
            this.priority = tag.func_74762_e("0");
            this.limit = tag.func_74763_f("1");
            this.disableLimit = tag.func_74767_n("2");
            this.surgeMode = tag.func_74767_n("3");
            this.networkID = tag.func_74762_e("4");
            this.playerUUID = tag.func_186857_a("5");
            this.customName = tag.func_74779_i("6");
            this.color = tag.func_74762_e("7");
            this.connected = tag.func_74767_n("8");
            this.folderID = tag.func_74762_e("9");
            for (int i = 0; i < this.connections.length; ++i) {
                this.connections[i] = tag.func_74771_c('c' + String.valueOf(i));
            }
            ((AbstractTransferHandler)this.getTransferHandler()).buffer = tag.func_74763_f("buf");
            this.chunkLoading = tag.func_74767_n("l");
        }
        if (type == NBTType.TILE_UPDATE) {
            this.getTransferHandler().readNetworkedNBT(tag);
        }
        if (type == NBTType.TILE_DROP) {
            long k = tag.func_74763_f("buffer");
            ((AbstractTransferHandler)this.getTransferHandler()).buffer = k > 0L ? k : ((AbstractTransferHandler)this.getTransferHandler()).buffer;
            this.priority = tag.func_74762_e(FluxConnectorBlockItem.PRIORITY);
            long l = tag.func_74763_f(FluxConnectorBlockItem.LIMIT);
            this.limit = l > 0L ? l : this.limit;
            this.disableLimit = tag.func_74767_n(FluxConnectorBlockItem.DISABLE_LIMIT);
            this.surgeMode = tag.func_74767_n(FluxConnectorBlockItem.SURGE_MODE);
            int i = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
            this.networkID = i > 0 ? i : this.networkID;
            String name = tag.func_74779_i(FluxConnectorBlockItem.CUSTOM_NAME);
            this.customName = name.isEmpty() ? this.customName : name;
            this.folderID = tag.func_74762_e("folderID");
        }
    }

    @Override
    public boolean canAccess(PlayerEntity player) {
        if (!this.network.isInvalid()) {
            if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(this.playerUUID)) {
                return true;
            }
            return this.network.getMemberPermission(player).canAccess();
        }
        return true;
    }

    public void sendFullUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public void sendTilePacketToUsing(byte packetID) {
        if (!this.field_145850_b.field_72995_K) {
            for (PlayerEntity playerEntity : this.playerUsing) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new TilePacketBufferPacket(this, this.field_174879_c, packetID));
            }
        }
    }

    public void sendTilePacketToNearby(byte packetID) {
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new TilePacketBufferPacket(this, this.field_174879_c, packetID));
        }
    }

    public void sendTilePacketToServer(byte packetID) {
        PacketHandler.INSTANCE.sendToServer((Object)new TilePacketBufferPacket(this, this.field_174879_c, packetID));
    }

    @Override
    public void writePacket(PacketBuffer buf, byte id) {
        switch (id) {
            case 0: {
                buf.func_211400_a(this.customName, 256);
                break;
            }
            case 1: {
                buf.writeInt(this.priority);
                break;
            }
            case 2: {
                buf.writeLong(this.limit);
                break;
            }
            case 3: {
                buf.writeBoolean(this.surgeMode);
                break;
            }
            case 4: {
                buf.writeBoolean(this.disableLimit);
                break;
            }
            case 5: {
                buf.writeBoolean(this.settings_changed);
                if (this.settings_changed) {
                    buf.func_211400_a(this.customName, 256);
                    buf.writeInt(this.priority);
                    buf.writeLong(this.limit);
                    buf.writeBoolean(this.surgeMode);
                    buf.writeBoolean(this.disableLimit);
                    buf.writeBoolean(this.chunkLoading);
                }
                buf.func_150786_a(this.getTransferHandler().writeNetworkedNBT(new CompoundNBT()));
            }
        }
    }

    @Override
    public void readPacket(PacketBuffer buf, byte id) {
        switch (id) {
            case 0: {
                this.customName = buf.func_150789_c(256);
                this.markLiteSettingChanged();
                break;
            }
            case 1: {
                this.priority = buf.readInt();
                this.sortNetworkConnections();
                break;
            }
            case 2: {
                this.limit = buf.readLong();
                this.markLiteSettingChanged();
                break;
            }
            case 3: {
                this.surgeMode = buf.readBoolean();
                this.sortNetworkConnections();
                break;
            }
            case 4: {
                this.disableLimit = buf.readBoolean();
                this.markLiteSettingChanged();
                break;
            }
            case 5: {
                if (buf.readBoolean()) {
                    this.customName = buf.func_150789_c(256);
                    this.priority = buf.readInt();
                    this.limit = buf.readLong();
                    this.surgeMode = buf.readBoolean();
                    this.disableLimit = buf.readBoolean();
                    this.chunkLoading = buf.readBoolean();
                    this.settings_changed = true;
                }
                this.getTransferHandler().readNetworkedNBT(buf.func_150793_b());
            }
        }
    }

    protected void sortNetworkConnections() {
        if (this.network instanceof FluxNetworkServer) {
            FluxNetworkServer fluxNetworkServer = (FluxNetworkServer)this.network;
            fluxNetworkServer.needSortConnections = true;
            this.markLiteSettingChanged();
        }
    }

    protected void markLiteSettingChanged() {
        if (this.network instanceof FluxNetworkServer) {
            FluxNetworkServer fluxNetworkServer = (FluxNetworkServer)this.network;
            fluxNetworkServer.markLiteSettingChanged(this);
            this.settings_changed = true;
        }
    }

    @Override
    public CompoundNBT copyConfiguration(CompoundNBT config) {
        return FluxUtils.copyConfiguration(this, config);
    }

    @Override
    public void pasteConfiguration(CompoundNBT config) {
        FluxUtils.pasteConfiguration(this, config);
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID;
    }

    public void updateTransfers(Direction ... dirs) {
        this.getTransferHandler().updateTransfers(dirs);
    }

    @Override
    public int getPriority() {
        return this.surgeMode ? Integer.MAX_VALUE : this.priority;
    }

    @Override
    public void open(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.add(player);
            this.sendFullUpdatePacket();
        }
    }

    @Override
    public void close(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.remove(player);
        }
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean isChunkLoaded() {
        return !this.func_145837_r();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isForcedLoading() {
        return this.chunkLoading;
    }

    @Override
    public long getCurrentLimit() {
        return this.disableLimit ? Long.MAX_VALUE : this.limit;
    }

    @Override
    public int getActualPriority() {
        return this.priority;
    }

    @Override
    public long getActualLimit() {
        return this.limit;
    }

    @Override
    public int getFolderID() {
        return this.folderID;
    }

    @Override
    public Coord4D getCoords() {
        if (this.coord4D == null) {
            this.coord4D = new Coord4D(this);
        }
        return this.coord4D;
    }

    @Override
    public boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public boolean getSurgeMode() {
        return this.surgeMode;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.getCustomName());
    }

    @Nullable
    public Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity entity) {
        return new ContainerConnector<TileFluxCore>(windowID, playerInventory, this);
    }
}

