/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.energy;

import javax.annotation.Nonnull;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public class FNEnergyStorage
implements IFNEnergyStorage,
IEnergyStorage {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;

    public FNEnergyStorage(long capacity) {
        this(capacity, capacity, capacity, 0L);
    }

    public FNEnergyStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0L);
    }

    public FNEnergyStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, 0L);
    }

    public FNEnergyStorage(long capacity, long maxReceive, long maxExtract, long energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = Math.max(0L, Math.min(capacity, energy));
    }

    @Override
    public long receiveEnergyL(long maxReceive, boolean simulate) {
        if (!this.canReceiveL()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public long extractEnergyL(long maxExtract, boolean simulate) {
        if (!this.canExtractL()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public long getEnergyStoredL() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.capacity;
    }

    @Override
    public boolean canExtractL() {
        return this.maxExtract > 0L;
    }

    @Override
    public boolean canReceiveL() {
        return this.maxReceive > 0L;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)Math.min(this.receiveEnergyL(maxReceive, simulate), Integer.MAX_VALUE);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)Math.min(this.extractEnergyL(maxExtract, simulate), Integer.MAX_VALUE);
    }

    public int getEnergyStored() {
        return (int)Math.min(this.getEnergyStoredL(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getMaxEnergyStoredL(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return this.canExtractL();
    }

    public boolean canReceive() {
        return this.canReceiveL();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IFNEnergyStorage.class, (Capability.IStorage)new CapStorage(), () -> new FNEnergyStorage(10000L));
    }

    private static class CapStorage
    implements Capability.IStorage<IFNEnergyStorage> {
        private CapStorage() {
        }

        public INBT writeNBT(Capability<IFNEnergyStorage> capability, @Nonnull IFNEnergyStorage instance, Direction side) {
            return LongNBT.func_229698_a_((long)instance.getEnergyStoredL());
        }

        public void readNBT(Capability<IFNEnergyStorage> capability, IFNEnergyStorage instance, Direction side, INBT nbt) {
            if (!(instance instanceof FNEnergyStorage)) {
                throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
            }
            ((FNEnergyStorage)instance).energy = ((LongNBT)nbt).func_150291_c();
        }
    }
}

