/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.misc;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.storage.FluxNetworkData;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public enum FluxConfigurationType {
    NETWORK("networkID"),
    PRIORITY("priority"),
    PRIORITY_SETTING("surgeMode"),
    TRANSFER("limit"),
    TRANSFER_SETTING("disableLimit");

    private final String key;

    private FluxConfigurationType(String key) {
        this.key = key;
    }

    public void copy(CompoundNBT nbt, @Nonnull TileFluxDevice tile) {
        switch (this) {
            case NETWORK: {
                if (!tile.getNetwork().isValid()) break;
                nbt.func_74768_a(this.key, tile.getNetwork().getNetworkID());
                break;
            }
            case PRIORITY: {
                nbt.func_74768_a(this.key, tile.getRawPriority());
                break;
            }
            case PRIORITY_SETTING: {
                nbt.func_74757_a(this.key, tile.getSurgeMode());
                break;
            }
            case TRANSFER: {
                nbt.func_74772_a(this.key, tile.getRawLimit());
                break;
            }
            case TRANSFER_SETTING: {
                nbt.func_74757_a(this.key, tile.getDisableLimit());
            }
        }
    }

    public void paste(@Nonnull CompoundNBT nbt, @Nonnull TileFluxDevice tile) {
        if (!nbt.func_74764_b(this.key)) {
            return;
        }
        switch (this) {
            case NETWORK: {
                IFluxNetwork network = FluxNetworkData.getNetwork(nbt.func_74762_e(this.key));
                if (tile.getDeviceType().isController() && !network.getConnections(FluxLogicType.CONTROLLER).isEmpty()) break;
                network.enqueueConnectionAddition(tile);
                break;
            }
            case PRIORITY: {
                tile.setPriority(nbt.func_74762_e(this.key));
                break;
            }
            case PRIORITY_SETTING: {
                tile.setSurgeMode(nbt.func_74767_n(this.key));
                break;
            }
            case TRANSFER: {
                tile.setTransferLimit(nbt.func_74763_f(this.key));
                break;
            }
            case TRANSFER_SETTING: {
                tile.setDisableLimit(nbt.func_74767_n(this.key));
            }
        }
    }
}

