/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.GlobalPos;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSecurity;
import sonar.fluxnetworks.common.connection.NetworkStatistics;

public interface IFluxNetwork {
    public int getNetworkID();

    public String getNetworkName();

    public void setNetworkName(String var1);

    public int getNetworkColor();

    public void setNetworkColor(int var1);

    public int getWirelessMode();

    public void setWirelessMode(int var1);

    public UUID getOwnerUUID();

    public void setOwnerUUID(UUID var1);

    public NetworkSecurity getSecurity();

    public NetworkStatistics getStatistics();

    public Collection<NetworkMember> getAllMembers();

    public Object2ObjectMap<UUID, NetworkMember> getMembersMap();

    public Optional<NetworkMember> getMemberByUUID(UUID var1);

    public Collection<IFluxDevice> getAllConnections();

    public Optional<IFluxDevice> getConnectionByPos(GlobalPos var1);

    default public void onEndServerTick() {
    }

    default public void onDelete() {
    }

    @Nonnull
    public AccessLevel getPlayerAccess(PlayerEntity var1);

    @Nonnull
    public <T extends IFluxDevice> List<T> getConnections(FluxLogicType var1);

    public long getBufferLimiter();

    public void markSortConnections();

    public void enqueueConnectionAddition(@Nonnull IFluxDevice var1);

    public void enqueueConnectionRemoval(@Nonnull IFluxDevice var1, boolean var2);

    public boolean isValid();

    public void writeCustomNBT(CompoundNBT var1, int var2);

    public void readCustomNBT(CompoundNBT var1, int var2);
}

