/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.GlobalPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.connection.BasicFluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.misc.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public class FluxClientCache {
    private static final Int2ObjectMap<IFluxNetwork> NETWORKS = new Int2ObjectOpenHashMap();
    public static boolean superAdmin = false;
    public static boolean detailedNetworkView = false;
    public static IFluxNetwork adminViewingNetwork = FluxNetworkInvalid.INSTANCE;
    private static FeedbackInfo feedback = FeedbackInfo.NONE;
    private static FeedbackInfo feedbackAction = FeedbackInfo.NONE;
    private static int feedbackTimer = 0;

    public static void release() {
        NETWORKS.clear();
    }

    public static void updateNetworks(@Nonnull Int2ObjectMap<CompoundNBT> serverSideNetworks, int type) {
        for (Int2ObjectMap.Entry entry : serverSideNetworks.int2ObjectEntrySet()) {
            int id = entry.getIntKey();
            CompoundNBT nbt = (CompoundNBT)entry.getValue();
            IFluxNetwork network = (IFluxNetwork)NETWORKS.get(id);
            if (type == 29) {
                if (network == null) continue;
                NETWORKS.remove(id);
                continue;
            }
            if (network == null) {
                network = new BasicFluxNetwork();
                network.readCustomNBT(nbt, type);
                NETWORKS.put(id, (Object)network);
                continue;
            }
            network.readCustomNBT(nbt, type);
        }
    }

    public static void updateConnections(int networkID, List<CompoundNBT> tags) {
        IFluxNetwork network = (IFluxNetwork)NETWORKS.get(networkID);
        if (network != null) {
            for (CompoundNBT tag : tags) {
                GlobalPos globalPos = FluxUtils.readGlobalPos(tag);
                network.getConnectionByPos(globalPos).ifPresent(c -> c.readCustomNBT(tag, 20));
            }
        }
    }

    @Nonnull
    public static IFluxNetwork getNetwork(int id) {
        return (IFluxNetwork)NETWORKS.getOrDefault(id, (Object)FluxNetworkInvalid.INSTANCE);
    }

    public static String getDisplayName(int networkID) {
        IFluxNetwork network = FluxClientCache.getNetwork(networkID);
        if (network.isValid()) {
            return network.getNetworkName();
        }
        return "NONE";
    }

    public static FeedbackInfo getFeedback(boolean action) {
        return action ? feedbackAction : feedback;
    }

    public static void setFeedback(FeedbackInfo info, boolean action) {
        if (action) {
            feedbackAction = info;
        } else {
            feedback = info;
        }
        feedbackTimer = 0;
    }

    public static void tick() {
        if (feedback.isValid() && ++feedbackTimer >= 60) {
            feedbackTimer = 0;
            FluxClientCache.setFeedback(FeedbackInfo.NONE, false);
        }
    }

    @Nonnull
    public static List<IFluxNetwork> getAllNetworks() {
        return new ArrayList<IFluxNetwork>((Collection<IFluxNetwork>)NETWORKS.values());
    }
}

