/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import org.lwjgl.opengl.GL11;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.misc.NumberFormatType;

public class LineChart {
    public int x;
    public int y;
    public int height;
    public int linePoints;
    public String displayUnitX;
    public String displayUnitY;
    public long maxUnitY;
    public String suffixUnitY;
    public LongList data = new LongArrayList();
    public DoubleList currentHeight;
    public DoubleList targetHeight;

    public LineChart(int x, int y, int height, int linePoints, String displayUnitX, String suffixUnitY) {
        int i;
        this.x = x;
        this.y = y;
        this.height = height;
        this.linePoints = linePoints;
        this.displayUnitX = displayUnitX;
        this.suffixUnitY = suffixUnitY;
        this.currentHeight = new DoubleArrayList(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.currentHeight.add((double)(y + height));
        }
        this.targetHeight = new DoubleArrayList(linePoints);
        for (i = 0; i < linePoints; ++i) {
            this.targetHeight.add((double)(y + height));
        }
    }

    public void drawChart(Minecraft mc, MatrixStack matrixStack) {
        int i;
        RenderSystem.pushLightingAttributes();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)773);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            GL11.glVertex3d((double)(this.x + 20 * i), (double)this.currentHeight.get(i), (double)1.0);
        }
        GL11.glEnd();
        RenderSystem.blendFuncSeparate((int)770, (int)773, (int)1, (int)0);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4354);
        GL11.glPointSize((float)8.0f);
        GL11.glBegin((int)0);
        for (i = 0; i < this.currentHeight.size(); ++i) {
            GL11.glVertex3d((double)(this.x + 20 * i), (double)this.currentHeight.get(i), (double)1.0);
        }
        GL11.glEnd();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(this.x - 16), (int)(this.y + this.height), (int)(this.x + 116), (int)(this.y + this.height + 1), (int)-1);
        Screen.func_238467_a_((MatrixStack)matrixStack, (int)(this.x - 14), (int)(this.y - 6), (int)(this.x - 13), (int)(this.y + this.height + 3), (int)-1);
        RenderSystem.scaled((double)0.625, (double)0.625, (double)0.625);
        mc.field_71466_p.func_238421_b_(matrixStack, this.suffixUnitY, (float)((double)(this.x - 15) * 1.6) - (float)mc.field_71466_p.func_78256_a(this.suffixUnitY), (float)(((double)this.y - 7.5) * 1.6), 0xFFFFFF);
        mc.field_71466_p.func_238421_b_(matrixStack, this.displayUnitY, (float)((double)(this.x - 15) * 1.6) - (float)mc.field_71466_p.func_78256_a(this.displayUnitY), (float)((double)(this.y - 2) * 1.6), 0xFFFFFF);
        mc.field_71466_p.func_238421_b_(matrixStack, this.displayUnitX, (float)((double)(this.x + 118) * 1.6 - (double)mc.field_71466_p.func_78256_a(this.displayUnitX)), (float)(((double)(this.y + this.height) + 1.5) * 1.6), 0xFFFFFF);
        for (i = 0; i < this.data.size(); ++i) {
            String d = FluxUtils.format(this.data.getLong(i), NumberFormatType.COMPACT, "");
            mc.field_71466_p.func_238421_b_(matrixStack, d, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(d) / 2.0f + 1.0f, (float)((this.currentHeight.getDouble(i) - 7.0) * 1.6), 0xFFFFFF);
            String c = String.valueOf((5 - i) * 5);
            mc.field_71466_p.func_238421_b_(matrixStack, c, (float)(this.x + 20 * i) * 1.6f - (float)mc.field_71466_p.func_78256_a(c) / 2.0f, (float)((double)(this.y + this.height + 2) * 1.6), 0xFFFFFF);
        }
        RenderSystem.scaled((double)1.6f, (double)1.6f, (double)1.6f);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.popAttributes();
    }

    public void updateData(LongList newData) {
        this.data = newData;
        this.calculateUnitY((List<Long>)newData);
        this.calculateTargetHeight((List<Long>)newData);
    }

    public void updateHeight(float partialTick) {
        if (this.currentHeight.size() == 0) {
            return;
        }
        for (int i = 0; i < this.currentHeight.size(); ++i) {
            double a = this.targetHeight.getDouble(i) - this.currentHeight.getDouble(i);
            if (a == 0.0) continue;
            double p = partialTick / 16.0f;
            double c = Math.abs(a) <= p ? this.targetHeight.getDouble(i) : (a > 0.0 ? this.currentHeight.getDouble(i) + Math.max(Math.min(a, a / 4.0 * (double)partialTick), p) : this.currentHeight.getDouble(i) + Math.min(Math.max(a, a / 4.0 * (double)partialTick), -p));
            this.currentHeight.set(i, c);
        }
    }

    private void calculateUnitY(List<Long> data) {
        long maxValue = 0L;
        for (long v : data) {
            maxValue = Math.max(maxValue, v);
        }
        if (maxValue == 0L) {
            this.maxUnitY = 1L;
            this.displayUnitY = FluxUtils.format(this.maxUnitY, NumberFormatType.COMPACT, "");
            return;
        }
        int measureLevel = (int)Math.log10(maxValue);
        switch (measureLevel) {
            case 0: {
                this.maxUnitY = maxValue + 1L;
                break;
            }
            case 1: {
                this.maxUnitY = (maxValue / 5L + 1L) * 5L;
                break;
            }
            case 2: {
                this.maxUnitY = (maxValue / 50L + 1L) * 50L;
                break;
            }
            default: {
                int p = (int)Math.pow(10.0, measureLevel - 1);
                this.maxUnitY = (maxValue / (long)p + 1L) * (long)p;
            }
        }
        this.displayUnitY = FluxUtils.format(this.maxUnitY, NumberFormatType.COMPACT, "");
    }

    private void calculateTargetHeight(List<Long> data) {
        if (data.size() != this.linePoints) {
            return;
        }
        int i = 0;
        for (Long value : data) {
            this.targetHeight.set(i, (double)this.y + (double)this.height * (1.0 - (double)value.longValue() / (double)this.maxUnitY));
            ++i;
        }
    }
}

