/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ScreenUtils
extends AbstractGui {
    @Deprecated
    public static final ResourceLocation BACKGROUND = new ResourceLocation("fluxnetworks", "textures/gui/gui_default_background.png");
    @Deprecated
    public static final ResourceLocation FRAME = new ResourceLocation("fluxnetworks", "textures/gui/gui_default_frame.png");
    @Deprecated
    public static final ResourceLocation GUI_BAR = new ResourceLocation("fluxnetworks", "textures/gui/gui_bar.png");
    @Deprecated
    public static final ResourceLocation BUTTONS = new ResourceLocation("fluxnetworks", "textures/gui/gui_button.png");
    public static final ResourceLocation INVENTORY = new ResourceLocation("fluxnetworks", "textures/gui/inventory_configuration.png");
    public static final ScreenUtils INSTANCE = new ScreenUtils();
    protected Minecraft minecraft = Minecraft.func_71410_x();
    protected ItemRenderer itemRenderer = this.minecraft.func_175599_af();
    protected FontRenderer font;

    public ScreenUtils() {
        this.font = this.minecraft.field_71466_p;
    }

    public static float getRed(int colour) {
        return (float)(colour >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int colour) {
        return (float)(colour >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int colour) {
        return (float)(colour & 0xFF) / 255.0f;
    }

    public void setGuiColouring(int colour) {
        RenderSystem.color3f((float)ScreenUtils.getRed(colour), (float)ScreenUtils.getGreen(colour), (float)ScreenUtils.getBlue(colour));
    }

    public void resetGuiColouring() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderNetwork(MatrixStack matrixStack, String name, int color, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_BAR);
        ScreenUtils.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)135, (int)12, (int)256, (int)256);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, name, (float)(x + 4), (float)(y + 2), 0xFFFFFF);
        RenderSystem.popMatrix();
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        this.renderItemStack(stack, x, y, "");
    }

    public void renderItemStack(ItemStack stack, int x, int y, String text) {
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(200);
        this.itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.font;
        }
        this.itemRenderer.func_180450_b(stack, x, y);
        this.itemRenderer.func_180453_a(font, stack, x, y, text);
        this.func_230926_e_(0);
        this.itemRenderer.field_77023_b = 0.0f;
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public void drawRectWithBackground(MatrixStack matrixStack, int x, int y, int height, int width, int frameColor, int backColor) {
        ScreenUtils.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)y, (int)frameColor);
        ScreenUtils.func_238467_a_((MatrixStack)matrixStack, (int)(x - 1), (int)(y + height), (int)(x + width + 1), (int)(y + height + 1), (int)frameColor);
        ScreenUtils.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)backColor);
    }

    public void drawHoverTooltip(MatrixStack matrixStack, List<String> strings, int x, int y) {
        int maxLength = 0;
        for (String s : strings) {
            maxLength = Math.max(this.font.func_78256_a(s), maxLength);
        }
        this.drawRectWithBackground(matrixStack, x, y, strings.size() * 9 + 3, maxLength + 4, -2130706433, -1073741824);
        for (int i = 0; i < strings.size(); ++i) {
            this.font.func_238421_b_(matrixStack, strings.get(i), (float)(x + 2), (float)(y + 2 + 9 * i), 0xFFFFFF);
        }
    }
}

