/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopUpHost;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.misc.NumberFormatType;
import sonar.fluxnetworks.common.network.CConfiguratorConnectMessage;
import sonar.fluxnetworks.common.network.CSelectNetworkMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class GuiFluxCore
extends GuiPopUpHost {
    public List<List<? extends GuiButtonCore>> buttonLists = Lists.newArrayList();
    protected List<NormalButton> field_230710_m_ = Lists.newArrayList();
    protected List<SlidedSwitchButton> switches = Lists.newArrayList();
    public IFluxNetwork network;
    public AccessLevel accessLevel = AccessLevel.BLOCKED;
    protected boolean networkValid;
    private int timer1;

    public GuiFluxCore(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.network = FluxClientCache.getNetwork(connector.getNetworkID());
        this.networkValid = this.network.isValid();
        this.network.getMemberByUUID(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH())).ifPresent(m -> {
            this.accessLevel = m.getAccessLevel();
        });
    }

    @Override
    public int getGuiColouring() {
        return this.network.getNetworkColor();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.buttonLists.clear();
        this.field_230710_m_.clear();
        this.switches.clear();
        this.buttonLists.add(this.field_230710_m_);
        this.buttonLists.add(this.switches);
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r)));
    }

    @Override
    protected void drawBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.updateButton(partialTicks, mouseX, mouseY)));
    }

    @Override
    public boolean mouseClickedMain(double mouseX, double mouseY, int mouseButton) {
        for (List<? extends GuiButtonCore> list : this.buttonLists) {
            for (GuiButtonCore guiButtonCore : list) {
                if (!guiButtonCore.clickable || !guiButtonCore.isMouseHovered(this.field_230706_i_, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r)) continue;
                this.onButtonClicked(guiButtonCore, (int)mouseX - this.field_147003_i, (int)mouseY - this.field_147009_r, mouseButton);
                return true;
            }
        }
        return super.mouseClickedMain(mouseX, mouseY, mouseButton);
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.timer1 == 0) {
            this.network = FluxClientCache.getNetwork(this.connector.getNetworkID());
            this.networkValid = this.network.isValid();
        }
        ++this.timer1;
        this.timer1 %= 20;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        FluxClientCache.setFeedback(FeedbackInfo.NONE, false);
        FluxClientCache.setFeedback(FeedbackInfo.NONE, true);
    }

    protected void renderNavigationPrompt(MatrixStack matrixStack, String error, String prompt) {
        RenderSystem.pushMatrix();
        GuiFluxCore.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)error, (int)(this.field_146999_f / 2), (int)16, (int)0x808080);
        RenderSystem.scaled((double)0.625, (double)0.625, (double)0.625);
        GuiFluxCore.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)FluxTranslate.CLICK_ABOVE.format(TextFormatting.AQUA + prompt + TextFormatting.RESET), (int)((int)((double)(this.field_146999_f / 2) * 1.6)), (int)41, (int)0x808080);
        RenderSystem.scaled((double)1.6, (double)1.6, (double)1.6);
        RenderSystem.popMatrix();
    }

    protected void renderTransfer(MatrixStack matrixStack, IFluxDevice flux, int color, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        this.screenUtils.resetGuiColouring();
        this.field_230712_o_.func_238421_b_(matrixStack, FluxUtils.getTransferInfo(flux, EnergyType.FE), (float)x, (float)y, color);
        this.field_230712_o_.func_238421_b_(matrixStack, (flux.getDeviceType().isStorage() ? FluxTranslate.ENERGY.t() : FluxTranslate.BUFFER.t()) + ": " + TextFormatting.BLUE + FluxUtils.format(flux.getTransferBuffer(), NumberFormatType.COMMAS, EnergyType.FE, false), (float)x, (float)(y + 10), 0xFFFFFF);
        this.screenUtils.renderItemStack(flux.getDisplayStack(), x - 20, y + 1);
        RenderSystem.popMatrix();
    }

    protected List<String> getFluxInfo(IFluxDevice flux) {
        ArrayList list = Lists.newArrayList();
        list.add(TextFormatting.BOLD + flux.getCustomName());
        if (flux.isChunkLoaded()) {
            if (flux.isForcedLoading()) {
                list.add(TextFormatting.AQUA + FluxTranslate.FORCED_LOADING.t());
            }
            list.add(FluxUtils.getTransferInfo(flux, EnergyType.FE));
        } else {
            list.add(TextFormatting.RED + FluxTranslate.CHUNK_UNLOADED.t());
        }
        if (flux.getDeviceType().isStorage()) {
            list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + FluxUtils.format(flux.getTransferBuffer(), NumberFormatType.COMMAS, EnergyType.FE, false));
        } else {
            list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + FluxUtils.format(flux.getTransferBuffer(), NumberFormatType.COMMAS, EnergyType.FE, false));
        }
        list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : FluxUtils.format(flux.getRawLimit(), NumberFormatType.COMMAS, EnergyType.FE, false)));
        list.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getRawPriority())));
        list.add(TextFormatting.ITALIC + FluxUtils.getDisplayString(flux.getGlobalPos()));
        return list;
    }

    public void onSuperAdminChanged() {
    }

    public void setConnectedNetwork(int networkID, String password) {
        if (this.connector instanceof TileFluxDevice) {
            NetworkHandler.INSTANCE.sendToServer(new CSelectNetworkMessage(((TileFluxDevice)this.connector).func_174877_v(), networkID, password));
        } else if (this.connector instanceof ItemAdminConfigurator.NetworkConnector) {
            FluxClientCache.adminViewingNetwork = FluxClientCache.getNetwork(networkID);
        } else if (this.connector instanceof ItemFluxConfigurator.NetworkConnector) {
            NetworkHandler.INSTANCE.sendToServer(new CConfiguratorConnectMessage(networkID, password));
        }
    }
}

