/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxConfiguratorHome;
import sonar.fluxnetworks.client.gui.GuiFluxDeviceHome;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.button.NavigationButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.client.gui.tab.GuiTabCreate;
import sonar.fluxnetworks.client.gui.tab.GuiTabDetailedSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabMembers;
import sonar.fluxnetworks.client.gui.tab.GuiTabSelection;
import sonar.fluxnetworks.client.gui.tab.GuiTabSettings;
import sonar.fluxnetworks.client.gui.tab.GuiTabStatistics;
import sonar.fluxnetworks.client.gui.tab.GuiTabWireless;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.registry.RegistrySounds;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class GuiTabCore
extends GuiFluxCore {
    protected List<NavigationButton> navigationButtons = Lists.newArrayList();
    public EnumNavigationTabs[] navigationTabs;

    public GuiTabCore(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        this.setDefaultTabs();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.navigationButtons.clear();
        this.buttonLists.add(this.navigationButtons);
    }

    public abstract EnumNavigationTabs getNavigationTab();

    public void setDefaultTabs() {
        this.navigationTabs = EnumNavigationTabs.values();
    }

    public void setNavigationTabs(EnumNavigationTabs[] navigationTabs) {
        this.navigationTabs = navigationTabs;
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof NavigationButton) {
            GuiTabCore.switchTab(((NavigationButton)button).tab, this.player, this.connector);
            if (FluxConfig.enableButtonSound) {
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
    }

    public void configureNavigationButtons(EnumNavigationTabs currentTab, EnumNavigationTabs[] availableTabs) {
        int posCount = 0;
        for (EnumNavigationTabs tab : availableTabs) {
            if (tab != EnumNavigationTabs.TAB_CREATE) {
                this.navigationButtons.add(new NavigationButton(12 + 18 * posCount, -16, tab));
                ++posCount;
                continue;
            }
            this.navigationButtons.add(new NavigationButton(148, -16, tab));
        }
        this.navigationButtons.get(currentTab.ordinal()).setMain();
    }

    public static void switchTab(EnumNavigationTabs tab, PlayerEntity player, INetworkConnector connector) {
        switch (tab) {
            case TAB_HOME: {
                if (connector instanceof TileFluxDevice) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxDeviceHome(player, (TileFluxDevice)connector));
                    break;
                }
                if (connector instanceof ItemAdminConfigurator.NetworkConnector) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxAdminHome(player, connector));
                    break;
                }
                if (connector instanceof ItemFluxConfigurator.NetworkConnector) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiFluxConfiguratorHome(player, (ItemFluxConfigurator.NetworkConnector)connector));
                    break;
                }
                player.func_71053_j();
                break;
            }
            case TAB_SELECTION: {
                if (connector instanceof ItemAdminConfigurator.NetworkConnector && FluxClientCache.detailedNetworkView) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabDetailedSelection(player, connector));
                    break;
                }
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabSelection(player, connector));
                break;
            }
            case TAB_WIRELESS: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabWireless(player, connector));
                break;
            }
            case TAB_CONNECTION: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabConnections(player, connector));
                break;
            }
            case TAB_STATISTICS: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabStatistics(player, connector));
                break;
            }
            case TAB_MEMBER: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabMembers(player, connector));
                break;
            }
            case TAB_SETTING: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabSettings(player, connector));
                break;
            }
            case TAB_CREATE: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiTabCreate(player, connector));
            }
        }
    }
}

