/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.button.ColorButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import sonar.fluxnetworks.common.network.CDeleteNetworkMessage;
import sonar.fluxnetworks.common.network.CEditNetworkMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public InvisibleButton redirectButton;
    public NormalButton apply;
    public NormalButton delete;
    public int deleteCount;

    public GuiTabSettings(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
        if (this.networkValid) {
            this.securityType = this.network.getSecurity().getType();
            this.energyType = EnergyType.FE;
        }
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE || this.networkValid) {
            if (mouseX > 30 + this.field_147003_i && mouseX < 66 + this.field_147003_i && mouseY > 140 + this.field_147009_r && mouseY < 152 + this.field_147009_r) {
                if (this.delete.clickable) {
                    GuiTabSettings.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(TextFormatting.BOLD + FluxTranslate.DELETE_NETWORK.t()), (int)48, (int)128, (int)0xFF0000);
                } else {
                    GuiTabSettings.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)FluxTranslate.DOUBLE_SHIFT.t(), (int)48, (int)128, (int)0xFFFFFF);
                }
            }
            GuiTabSettings.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(TextFormatting.RED + FluxClientCache.getFeedback(false).getText()), (int)88, (int)156, (int)0xFFFFFF);
        } else {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.networkValid) {
            this.nameField.func_146180_a(this.network.getNetworkName());
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 112, 140, 36, 12, 3).setUnclickable();
            this.field_230710_m_.add(this.apply);
            this.delete = new NormalButton(FluxTranslate.DELETE.t(), 30, 140, 36, 12, 4).setUnclickable();
            this.field_230710_m_.add(this.delete);
            int i = 0;
            boolean colorSet = false;
            for (EnumNetworkColor color : EnumNetworkColor.values()) {
                ColorButton b2 = new ColorButton(48 + (i >= 7 ? i - 7 : i) * 16, 96 + (i >= 7 ? 1 : 0) * 16, color.getRGB());
                this.colorButtons.add(b2);
                if (!colorSet && color.getRGB() == this.network.getNetworkColor()) {
                    this.colorBtn = b2;
                    this.colorBtn.selected = true;
                    colorSet = true;
                }
                ++i;
            }
            if (!colorSet) {
                ColorButton c = new ColorButton(32, 112, this.network.getNetworkColor());
                this.colorButtons.add(c);
                this.colorBtn = c;
                this.colorBtn.selected = true;
            }
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabSettings.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.networkValid && this.apply != null) {
            this.apply.clickable = (this.securityType != SecurityType.ENCRYPTED || this.passwordField.func_146179_b().length() != 0) && this.nameField.func_146179_b().length() != 0;
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (this.networkValid && button instanceof NormalButton) {
            switch (button.id) {
                case 3: {
                    NetworkHandler.INSTANCE.sendToServer(new CEditNetworkMessage(this.network.getNetworkID(), this.nameField.func_146179_b(), this.colorBtn.color, this.securityType, this.passwordField.func_146179_b()));
                    break;
                }
                case 4: {
                    NetworkHandler.INSTANCE.sendToServer(new CDeleteNetworkMessage(this.connector.getNetworkID()));
                }
            }
        }
    }

    @Override
    public boolean keyPressedMain(int keyCode, int scanCode, int modifiers) {
        if (this.delete != null) {
            if (keyCode == 340) {
                ++this.deleteCount;
                if (this.deleteCount > 1) {
                    this.delete.clickable = true;
                }
            } else {
                this.deleteCount = 0;
                this.delete.clickable = false;
            }
        }
        return super.keyPressedMain(keyCode, scanCode, modifiers);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (FluxClientCache.getFeedback(true) == FeedbackInfo.SUCCESS) {
            GuiTabSettings.switchTab(EnumNavigationTabs.TAB_HOME, this.player, this.connector);
            FluxClientCache.setFeedback(FeedbackInfo.NONE, true);
        }
        if (FluxClientCache.getFeedback(true) == FeedbackInfo.SUCCESS_2) {
            this.apply.clickable = false;
            FluxClientCache.setFeedback(FeedbackInfo.NONE, true);
        }
    }
}

