/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTabs;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.network.ChargingType;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InventoryButton;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.network.CEditWirelessMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;

public class GuiTabWireless
extends GuiTabCore {
    public InvisibleButton redirectButton;
    public List<InventoryButton> inventoryButtonList = new ArrayList<InventoryButton>();
    public NormalButton apply;
    public int settings;

    public GuiTabWireless(PlayerEntity player, INetworkConnector connector) {
        super(player, connector);
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_WIRELESS;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.networkValid) {
            int colour = this.network.getNetworkColor();
            GuiTabWireless.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)FluxTranslate.TAB_WIRELESS.t(), (int)88, (int)12, (int)0xB4B4B4);
            this.field_230712_o_.func_238421_b_(matrixStack, FluxTranslate.ENABLE_WIRELESS.t(), 20.0f, 156.0f, colour);
            GuiTabWireless.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(TextFormatting.RED + FluxClientCache.getFeedback(false).getText()), (int)88, (int)146, (int)0xFFFFFF);
        } else {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_WIRELESS, this.navigationTabs);
        this.inventoryButtonList.clear();
        this.buttonLists.add(this.inventoryButtonList);
        if (this.networkValid) {
            this.settings = this.network.getWirelessMode();
            this.switches.add(new SlidedSwitchButton(140, 156, 4, this.field_147003_i, this.field_147009_r, ChargingType.ENABLE_WIRELESS.isActivated(this.settings)));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.ARMOR, this, 24, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.CURIOS, this, 100, 32, 0, 80, 52, 16));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.INVENTORY, this, 32, 56, 0, 0, 112, 40));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.HOT_BAR, this, 32, 104, 112, 0, 112, 16));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.MAIN_HAND, this, 136, 128, 52, 80, 16, 16));
            this.inventoryButtonList.add(new InventoryButton(ChargingType.OFF_HAND, this, 24, 128, 52, 80, 16, 16));
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 73, 130, 32, 12, 0).setUnclickable();
            this.field_230710_m_.add(this.apply);
        } else {
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTabs.TAB_SELECTION.getTranslatedName(), b -> GuiTabWireless.switchTab(EnumNavigationTabs.TAB_SELECTION, this.player, this.connector));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof InventoryButton) {
            this.switchSetting(((InventoryButton)button).chargeType);
        }
        if (button instanceof NormalButton && button.id == 0) {
            NetworkHandler.INSTANCE.sendToServer(new CEditWirelessMessage(this.network.getNetworkID(), this.settings));
        }
        if (button instanceof SlidedSwitchButton) {
            ((SlidedSwitchButton)button).switchButton();
            if (button.id == 4) {
                this.switchSetting(ChargingType.ENABLE_WIRELESS);
            }
        }
    }

    public void switchSetting(ChargingType type) {
        this.settings ^= 1 << type.ordinal();
        this.apply.clickable = true;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.apply != null && FluxClientCache.getFeedback(true) == FeedbackInfo.SUCCESS) {
            this.apply.clickable = false;
            FluxClientCache.setFeedback(FeedbackInfo.NONE, true);
        }
    }
}

