/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.api.text.StyleUtils;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public abstract class FluxDeviceBlock
extends Block {
    public FluxDeviceBlock(AbstractBlock.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult result) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemFluxConfigurator) {
            return ActionResultType.FAIL;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileFluxDevice) {
            TileFluxDevice flux = (TileFluxDevice)tile;
            if (!flux.playerUsing.isEmpty()) {
                player.func_146105_b(StyleUtils.error(FluxTranslate.ACCESS_OCCUPY), true);
                return ActionResultType.SUCCESS;
            }
            if (flux.canPlayerAccess(player)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)flux, buf -> {
                    buf.writeBoolean(true);
                    buf.func_179255_a(pos);
                });
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b(StyleUtils.error(FluxTranslate.ACCESS_DENIED), true);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileFluxDevice) {
            CompoundNBT tag;
            TileFluxDevice flux = (TileFluxDevice)tile;
            if (stack.func_77942_o() && (tag = stack.func_179543_a("FluxData")) != null) {
                flux.readCustomNBT(tag, 15);
            }
            if (placer instanceof ServerPlayerEntity) {
                flux.setConnectionOwner(PlayerEntity.func_146094_a((GameProfile)((PlayerEntity)placer).func_146103_bH()));
            }
        }
    }

    public boolean removedByPlayer(BlockState state, @Nonnull World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileFluxDevice && !((TileFluxDevice)tile).canPlayerAccess(player)) {
            player.func_146105_b(StyleUtils.error(FluxTranslate.REMOVAL_DENIED), true);
            return false;
        }
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, fluid.func_206883_i(), world.field_72995_K ? 11 : 3);
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }
}

