/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.FluxDeviceType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.ITransferHandler;
import sonar.fluxnetworks.common.misc.FluxUtils;

public class PhantomFluxDevice
implements IFluxDevice {
    private int networkID;
    private String customName;
    private int priority;
    private long limit;
    private UUID playerUUID;
    private FluxDeviceType deviceType;
    private GlobalPos globalPos;
    private boolean surgeMode;
    private boolean disableLimit;
    private boolean chunkLoaded;
    private boolean forcedLoading;
    private long buffer;
    private long change;
    private ItemStack stack;

    public PhantomFluxDevice() {
    }

    public PhantomFluxDevice(@Nonnull IFluxDevice device) {
        if (device instanceof PhantomFluxDevice || device.getFluxWorld().field_72995_K) {
            throw new IllegalArgumentException();
        }
        this.networkID = device.getNetworkID();
        this.customName = device.getCustomName();
        this.priority = device.getRawPriority();
        this.limit = device.getRawLimit();
        this.playerUUID = device.getConnectionOwner();
        this.deviceType = device.getDeviceType();
        this.globalPos = device.getGlobalPos();
        this.surgeMode = device.getSurgeMode();
        this.disableLimit = device.getDisableLimit();
        this.buffer = device.getTransferBuffer();
        this.stack = device.getDisplayStack();
    }

    public PhantomFluxDevice(@Nonnull GlobalPos globalPos, CompoundNBT tag) {
        this.globalPos = globalPos;
        this.readCustomNBT(tag, 20);
    }

    @Override
    public void writeCustomNBT(CompoundNBT tag, int type) {
        if (type == 1 || type == 20) {
            FluxUtils.writeGlobalPos(tag, this.globalPos);
            tag.func_74774_a("deviceType", (byte)this.deviceType.ordinal());
            tag.func_74768_a("networkID", this.networkID);
            tag.func_74778_a("customName", this.customName);
            tag.func_74768_a("priority", this.priority);
            tag.func_74772_a("limit", this.limit);
            tag.func_74757_a("surgeMode", this.surgeMode);
            tag.func_74757_a("disableLimit", this.disableLimit);
            tag.func_186854_a("playerUUID", this.playerUUID);
            tag.func_74772_a("buffer", this.buffer);
            this.stack.func_77955_b(tag);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT tag, int type) {
        if (type == 1) {
            this.globalPos = FluxUtils.readGlobalPos(tag);
        }
        if (type == 1 || type == 20) {
            this.deviceType = FluxDeviceType.values()[tag.func_74771_c("deviceType")];
            this.networkID = tag.func_74762_e("networkID");
            this.customName = tag.func_74779_i("customName");
            this.priority = tag.func_74762_e("priority");
            this.limit = tag.func_74763_f("limit");
            this.surgeMode = tag.func_74767_n("surgeMode");
            this.disableLimit = tag.func_74767_n("disableLimit");
            this.playerUUID = tag.func_186857_a("playerUUID");
            this.buffer = tag.func_74763_f("buffer");
            this.stack = ItemStack.func_199557_a((CompoundNBT)tag);
        }
        if (type == 20) {
            this.forcedLoading = tag.func_74767_n("forcedLoading");
            this.chunkLoaded = tag.func_74767_n("chunkLoaded");
            this.change = tag.func_74763_f("change");
        }
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Override
    public int getLogicPriority() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public int getRawPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public IFluxNetwork getNetwork() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onContainerOpened(PlayerEntity player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onContainerClosed(PlayerEntity player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID;
    }

    @Override
    public FluxDeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public boolean canPlayerAccess(PlayerEntity player) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public boolean isChunkLoaded() {
        return this.chunkLoaded;
    }

    @Override
    public boolean isForcedLoading() {
        return this.forcedLoading;
    }

    @Override
    public void setForcedLoading(boolean forcedLoading) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onConnect(IFluxNetwork network) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public void onDisconnect() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    @Nonnull
    public ITransferHandler getTransferHandler() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    @Nonnull
    public World getFluxWorld() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public long getLogicLimit() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public long getRawLimit() {
        return this.limit;
    }

    @Override
    public void setTransferLimit(long limit) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public long getMaxTransferLimit() {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    @Nonnull
    public GlobalPos getGlobalPos() {
        return this.globalPos;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String customName) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public void setDisableLimit(boolean disableLimit) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    public boolean getSurgeMode() {
        return this.surgeMode;
    }

    @Override
    public void setSurgeMode(boolean surgeMode) {
        throw new IllegalStateException("Logic method cannot be invoked on phantom device");
    }

    @Override
    @Nonnull
    public ItemStack getDisplayStack() {
        return this.stack;
    }

    @Override
    public long getTransferBuffer() {
        return this.buffer;
    }

    @Override
    public long getTransferChange() {
        return this.change;
    }
}

