/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import sonar.fluxnetworks.api.misc.FluxConfigurationType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.api.text.StyleUtils;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.common.misc.ContainerConnector;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

public class ItemFluxConfigurator
extends Item {
    public ItemFluxConfigurator(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        TileEntity tile = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (tile instanceof TileFluxDevice) {
            TileFluxDevice flux = (TileFluxDevice)tile;
            if (!flux.canPlayerAccess(context.func_195999_j())) {
                player.func_146105_b(StyleUtils.error(FluxTranslate.ACCESS_DENIED), true);
                return ActionResultType.FAIL;
            }
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            if (player.func_225608_bj_()) {
                CompoundNBT configs = new CompoundNBT();
                for (FluxConfigurationType type : FluxConfigurationType.values()) {
                    type.copy(configs, flux);
                }
                stack.func_77983_a("FluxConfig", (INBT)configs);
                player.func_145747_a((ITextComponent)new StringTextComponent("Copied Configuration"), UUID.randomUUID());
            } else {
                CompoundNBT configs = stack.func_179543_a("FluxConfig");
                if (configs != null) {
                    for (FluxConfigurationType type : FluxConfigurationType.values()) {
                        type.paste(configs, flux);
                    }
                    player.func_145747_a((ITextComponent)new StringTextComponent("Pasted Configuration"), UUID.randomUUID());
                }
            }
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(), buf -> buf.writeBoolean(false));
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(), buf -> buf.writeBoolean(false));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_179543_a("FluxConfig");
        if (tag != null) {
            tooltip.add((ITextComponent)new StringTextComponent(FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.WHITE + FluxClientCache.getDisplayName(tag.func_74762_e("networkID"))));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static class ContainerProvider
    implements INamedContainerProvider {
        @Nonnull
        public ITextComponent func_145748_c_() {
            return StringTextComponent.field_240750_d_;
        }

        @Nullable
        public Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
            return new ContainerConnector<Object>(windowID, playerInventory, null);
        }
    }

    public static class NetworkConnector
    implements INetworkConnector {
        public final ItemStack stack;
        public int networkID;

        public NetworkConnector(@Nonnull ItemStack stack) {
            this.stack = stack;
            CompoundNBT tag = stack.func_179543_a("FluxConfig");
            this.networkID = tag != null ? tag.func_74762_e("networkID") : -1;
        }

        @Override
        public int getNetworkID() {
            return this.networkID;
        }

        @Override
        public IFluxNetwork getNetwork() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onContainerOpened(PlayerEntity player) {
        }

        @Override
        public void onContainerClosed(PlayerEntity player) {
        }
    }
}

