/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.misc.NumberFormatType;

public class ItemFluxDevice
extends BlockItem {
    public ItemFluxDevice(Block block, Item.Properties props) {
        super(block, props);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("FluxData");
        if (tag != null && tag.func_74764_b("customName")) {
            return new StringTextComponent(tag.func_74779_i("customName"));
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_179543_a("FluxData");
        if (tag != null) {
            if (tag.func_74764_b("networkID")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.RESET + FluxClientCache.getDisplayName(tag.func_74762_e("networkID"))));
            }
            if (tag.func_74764_b("limit")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.RESET + FluxUtils.format(tag.func_74763_f("limit"), NumberFormatType.COMMAS, EnergyType.FE, false)));
            }
            if (tag.func_74764_b("priority")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.PRIORITY.t() + ": " + TextFormatting.RESET + tag.func_74762_e("priority")));
            }
            if (tag.func_74764_b("buffer")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.RESET + FluxUtils.format(tag.func_74763_f("buffer"), NumberFormatType.COMMAS, EnergyType.FE, false)));
            } else if (tag.func_74764_b("energy")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.RESET + FluxUtils.format(tag.func_74763_f("energy"), NumberFormatType.COMMAS, EnergyType.FE, false)));
            }
        } else {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }
    }
}

