/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.misc;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.network.FluxDeviceType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.common.misc.NumberFormatType;

public class FluxUtils {
    private FluxUtils() {
    }

    @Nonnull
    public static <E extends Enum<?>> E incrementEnum(@Nonnull E val, @Nonnull E[] values) {
        int next = val.ordinal() + 1;
        if (next < values.length) {
            return values[next];
        }
        return values[0];
    }

    @Nullable
    public static Direction getBlockDirection(BlockPos pos, BlockPos other) {
        for (Direction face : Direction.values()) {
            if (!pos.func_177972_a(face).equals((Object)other)) continue;
            return face;
        }
        return null;
    }

    @Nonnull
    public static String getTransferInfo(@Nonnull IFluxDevice flux, EnergyType energyType) {
        FluxDeviceType type = flux.getDeviceType();
        long change = flux.getTransferChange();
        if (type.isPlug()) {
            if (change == 0L) {
                return FluxTranslate.INPUT.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.INPUT.t() + ": " + TextFormatting.GREEN + "+" + FluxUtils.format(change, NumberFormatType.COMMAS, energyType, true);
        }
        if (type.isPoint() || type.isController()) {
            if (change == 0L) {
                return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            return FluxTranslate.OUTPUT.t() + ": " + TextFormatting.RED + FluxUtils.format(change, NumberFormatType.COMMAS, energyType, true);
        }
        if (type.isStorage()) {
            if (change == 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GOLD + "0 " + energyType.getUsageSuffix();
            }
            if (change > 0L) {
                return FluxTranslate.CHANGE.t() + ": " + TextFormatting.GREEN + "+" + FluxUtils.format(change, NumberFormatType.COMMAS, energyType, true);
            }
            return FluxTranslate.CHANGE.t() + ": " + TextFormatting.RED + FluxUtils.format(change, NumberFormatType.COMMAS, energyType, true);
        }
        return "";
    }

    @Nonnull
    public static GlobalPos getGlobalPos(@Nonnull TileEntity tileEntity) {
        return GlobalPos.func_239648_a_((RegistryKey)Objects.requireNonNull(tileEntity.func_145831_w()).func_234923_W_(), (BlockPos)tileEntity.func_174877_v());
    }

    public static void writeGlobalPos(@Nonnull CompoundNBT nbt, @Nonnull GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        nbt.func_74768_a("x", p.func_177958_n());
        nbt.func_74768_a("y", p.func_177956_o());
        nbt.func_74768_a("z", p.func_177952_p());
        nbt.func_74778_a("dim", pos.func_239646_a_().func_240901_a_().toString());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull CompoundNBT nbt) {
        return GlobalPos.func_239648_a_((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim"))), (BlockPos)new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")));
    }

    public static void writeGlobalPos(@Nonnull PacketBuffer buffer, @Nonnull GlobalPos pos) {
        buffer.func_211400_a(pos.func_239646_a_().func_240901_a_().toString(), 256);
        buffer.func_179255_a(pos.func_218180_b());
    }

    @Nonnull
    public static GlobalPos readGlobalPos(@Nonnull PacketBuffer buffer) {
        RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buffer.func_150789_c(256)));
        return GlobalPos.func_239648_a_((RegistryKey)dim, (BlockPos)buffer.func_179259_c());
    }

    @Nonnull
    public static String getDisplayString(@Nonnull GlobalPos pos) {
        BlockPos p = pos.func_218180_b();
        return "X: " + p.func_177958_n() + " Y: " + p.func_177956_o() + " Z: " + p.func_177952_p() + " (" + pos.func_239646_a_().func_240901_a_() + ")";
    }

    public static <T> boolean addWithCheck(@Nonnull Collection<T> list, @Nullable T toAdd) {
        if (toAdd != null && !list.contains(toAdd)) {
            list.add(toAdd);
            return true;
        }
        return false;
    }

    public static int getIntFromColor(int red, int green, int blue) {
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }

    public static int getBrighterColor(int color, float factor) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)Math.min((float)red * factor, 255.0f);
        green = (int)Math.min((float)green * factor, 255.0f);
        blue = (int)Math.min((float)blue * factor, 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static String format(long in, @Nonnull NumberFormatType style, String suffix) {
        switch (style) {
            case FULL: {
                return in + suffix;
            }
            case COMPACT: {
                if (in < 1000L) {
                    return in + suffix;
                }
                int exp = (int)(Math.log10(in) / 3.0);
                char pre = "kMGTPE".charAt(exp - 1);
                long base = 1000L;
                for (int i = 1; i < exp; ++i) {
                    base *= 1000L;
                }
                return String.format("%.1f%c", (double)in / (double)base, Character.valueOf(pre)) + suffix;
            }
            case COMMAS: {
                return NumberFormat.getInstance().format(in) + suffix;
            }
            case NONE: {
                return suffix;
            }
        }
        return Long.toString(in);
    }

    public static String format(long in, NumberFormatType style, EnergyType energy, boolean usage) {
        return FluxUtils.format(energy == EnergyType.EU ? in >> 2 : in, style, " " + (usage ? energy.getUsageSuffix() : energy.getStorageSuffix()));
    }

    public static boolean checkPassword(@Nonnull String str) {
        for (int i = 0; i < str.length(); ++i) {
            int codePoint;
            int c1 = str.charAt(i);
            if (Character.isHighSurrogate((char)c1) && i + 1 < str.length()) {
                char c2 = str.charAt(i + 1);
                if (Character.isLowSurrogate(c2)) {
                    codePoint = Character.toCodePoint((char)c1, c2);
                    ++i;
                } else {
                    codePoint = c1;
                }
            } else {
                codePoint = c1;
            }
            if (codePoint >= 33 && codePoint < 127) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T getCap(@Nonnull PlayerEntity player, Capability<T> capability) {
        return FluxUtils.getCap(player.getCapability(capability));
    }

    @Nullable
    public static <T> T getCap(@Nonnull LazyOptional<T> lazyOptional) {
        if (lazyOptional.isPresent()) {
            return (T)lazyOptional.orElseThrow(IllegalStateException::new);
        }
        return null;
    }

    @Nullable
    public static PlayerEntity getPlayer(@Nonnull NetworkEvent.Context context) {
        if (context.getDirection().getOriginationSide().isClient()) {
            return context.getSender();
        }
        return Inner.getPlayer();
    }

    private static class Inner {
        private Inner() {
        }

        @Nullable
        private static PlayerEntity getPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

