/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.CSelectNetworkMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public class CConfiguratorConnectMessage
implements IMessage {
    private int id;
    private String password;

    public CConfiguratorConnectMessage() {
    }

    public CConfiguratorConnectMessage(int id, String password) {
        this.id = id;
        this.password = password;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.id);
        buffer.func_211400_a(this.password, 256);
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = FluxUtils.getPlayer(context);
        if (player == null) {
            return;
        }
        int networkID = buffer.func_150792_a();
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (network.isValid()) {
            if (CSelectNetworkMessage.checkAccess(buffer, context, player, network)) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemFluxConfigurator) {
                CompoundNBT configs = stack.func_190925_c("FluxConfig");
                configs.func_74768_a("networkID", networkID);
            }
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
        }
    }
}

