/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.SecurityType;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public class CCreateNetworkMessage
implements IMessage {
    protected String name;
    protected int color;
    protected SecurityType security;
    protected String password;

    public CCreateNetworkMessage() {
    }

    public CCreateNetworkMessage(String name, int color, SecurityType security, String password) {
        this.name = name;
        this.color = color;
        this.security = security;
        this.password = password;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_211400_a(this.name, 256);
        buffer.writeInt(this.color);
        buffer.func_150787_b(this.security.ordinal());
        buffer.func_211400_a(this.password, 256);
    }

    @Override
    public final void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = FluxUtils.getPlayer(context);
        if (player == null) {
            return;
        }
        this.name = buffer.func_150789_c(256);
        this.color = buffer.readInt();
        this.security = SecurityType.values()[buffer.func_150792_a()];
        this.password = buffer.func_150789_c(256);
        if (FluxUtils.checkPassword(this.password)) {
            this.handle(buffer, context, player);
        } else {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.ILLEGAL_PASSWORD), context);
        }
    }

    protected void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context, PlayerEntity player) {
        if (FluxNetworkData.get().createNetwork(player, this.name, this.color, this.security, this.password) != null) {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
        } else {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_SPACE), context);
        }
    }
}

