/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.misc.FeedbackInfo;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.network.SNetworkUpdateMessage;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public class CEditMemberMessage
implements IMessage {
    private int networkID;
    private UUID playerChanged;
    private int type;

    public CEditMemberMessage() {
    }

    public CEditMemberMessage(int networkID, UUID playerChanged, int type) {
        this.networkID = networkID;
        this.playerChanged = playerChanged;
        this.type = type;
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.networkID);
        buffer.func_179252_a(this.playerChanged);
        buffer.func_150787_b(this.type);
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        PlayerEntity player = FluxUtils.getPlayer(context);
        if (player == null) {
            return;
        }
        int networkID = buffer.func_150792_a();
        UUID playerChanged = buffer.func_179253_g();
        int type = buffer.func_150792_a();
        if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(playerChanged)) {
            return;
        }
        IFluxNetwork network = FluxNetworkData.getNetwork(networkID);
        if (!network.isValid()) {
            return;
        }
        if (!network.getPlayerAccess(player).canEdit()) {
            NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_ADMIN), context);
            return;
        }
        if (type == 1) {
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(playerChanged);
            if (target != null) {
                NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.USER);
                network.getMembersMap().put((Object)m.getPlayerUUID(), (Object)m);
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
                NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(network, 22), context);
            } else {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.INVALID_USER), context);
            }
        } else {
            Optional<NetworkMember> member = network.getMemberByUUID(playerChanged);
            if (member.isPresent()) {
                NetworkMember p = member.get();
                if (type == 2) {
                    if (!network.getPlayerAccess(player).canDelete()) {
                        NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_OWNER), context);
                        return;
                    }
                    p.setAccessLevel(AccessLevel.ADMIN);
                } else if (type == 3) {
                    p.setAccessLevel(AccessLevel.USER);
                } else if (type == 4) {
                    network.getMembersMap().remove((Object)playerChanged);
                } else if (type == 5) {
                    if (!network.getPlayerAccess(player).canDelete()) {
                        NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.NO_OWNER), context);
                        return;
                    }
                    network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                    network.setOwnerUUID(playerChanged);
                    p.setAccessLevel(AccessLevel.OWNER);
                }
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
                NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(network, 22), context);
            } else if (type == 5) {
                ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(playerChanged);
                if (target != null) {
                    network.getAllMembers().removeIf(f -> f.getAccessLevel().canDelete());
                    NetworkMember m = NetworkMember.create((PlayerEntity)target, AccessLevel.OWNER);
                    network.getMembersMap().put((Object)m.getPlayerUUID(), (Object)m);
                    network.setOwnerUUID(playerChanged);
                    NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.SUCCESS), context);
                    NetworkHandler.INSTANCE.reply(new SNetworkUpdateMessage(network, 22), context);
                } else {
                    NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.INVALID_USER), context);
                }
            } else {
                NetworkHandler.INSTANCE.reply(new SFeedbackMessage(FeedbackInfo.INVALID_USER), context);
            }
        }
    }
}

