/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ByteArrayMap;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkInstance;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.common.network.CConfiguratorConnectMessage;
import sonar.fluxnetworks.common.network.CConfiguratorSettingMessage;
import sonar.fluxnetworks.common.network.CConnectionUpdateMessage;
import sonar.fluxnetworks.common.network.CCreateNetworkMessage;
import sonar.fluxnetworks.common.network.CDeleteNetworkMessage;
import sonar.fluxnetworks.common.network.CEditConnectionsMessage;
import sonar.fluxnetworks.common.network.CEditMemberMessage;
import sonar.fluxnetworks.common.network.CEditNetworkMessage;
import sonar.fluxnetworks.common.network.CEditWirelessMessage;
import sonar.fluxnetworks.common.network.CGuiPermissionMessage;
import sonar.fluxnetworks.common.network.CNetworkUpdateMessage;
import sonar.fluxnetworks.common.network.CSelectNetworkMessage;
import sonar.fluxnetworks.common.network.CSuperAdminMessage;
import sonar.fluxnetworks.common.network.FluxTileMessage;
import sonar.fluxnetworks.common.network.SConnectionUpdateMessage;
import sonar.fluxnetworks.common.network.SFeedbackMessage;
import sonar.fluxnetworks.common.network.SGuiPermissionMessage;
import sonar.fluxnetworks.common.network.SLavaParticleMessage;
import sonar.fluxnetworks.common.network.SNetworkUpdateMessage;
import sonar.fluxnetworks.common.network.SSuperAdminMessage;

public enum NetworkHandler {
    INSTANCE("fluxnetworks", "main_network");

    private final Byte2ObjectArrayMap<Supplier<? extends IMessage>> indices = new Byte2ObjectArrayMap();
    private final Object2ByteArrayMap<Class<? extends IMessage>> types = new Object2ByteArrayMap();
    private final NetworkInstance network;
    private final String protocol;
    private byte index = (byte)-128;

    private NetworkHandler(String modid, String name) {
        this.types.defaultReturnValue((byte)127);
        this.protocol = ((IModInfo)ModList.get().getModFileById(modid).getMods().get(0)).getVersion().getQualifier();
        NetworkRegistry.ChannelBuilder builder = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, name)).networkProtocolVersion(this::getProtocolVersion).clientAcceptedVersions(this::verifyServerProtocol).serverAcceptedVersions(this::verifyClientProtocol);
        try {
            this.network = (NetworkInstance)ObfuscationReflectionHelper.findMethod(NetworkRegistry.ChannelBuilder.class, (String)"createNetworkInstance", (Class[])new Class[0]).invoke((Object)builder, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        this.network.addListener(this::onS2CMessageReceived);
        this.network.addListener(this::onC2SMessageReceived);
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(FluxTileMessage.class, FluxTileMessage::new);
        INSTANCE.registerMessage(SFeedbackMessage.class, SFeedbackMessage::new);
        INSTANCE.registerMessage(SSuperAdminMessage.class, SSuperAdminMessage::new);
        INSTANCE.registerMessage(CSuperAdminMessage.class, CSuperAdminMessage::new);
        INSTANCE.registerMessage(CEditMemberMessage.class, CEditMemberMessage::new);
        INSTANCE.registerMessage(CEditNetworkMessage.class, CEditNetworkMessage::new);
        INSTANCE.registerMessage(CEditWirelessMessage.class, CEditWirelessMessage::new);
        INSTANCE.registerMessage(SLavaParticleMessage.class, SLavaParticleMessage::new);
        INSTANCE.registerMessage(CNetworkUpdateMessage.class, CNetworkUpdateMessage::new);
        INSTANCE.registerMessage(SNetworkUpdateMessage.class, SNetworkUpdateMessage::new);
        INSTANCE.registerMessage(CSelectNetworkMessage.class, CSelectNetworkMessage::new);
        INSTANCE.registerMessage(CCreateNetworkMessage.class, CCreateNetworkMessage::new);
        INSTANCE.registerMessage(CDeleteNetworkMessage.class, CDeleteNetworkMessage::new);
        INSTANCE.registerMessage(CGuiPermissionMessage.class, CGuiPermissionMessage::new);
        INSTANCE.registerMessage(SGuiPermissionMessage.class, SGuiPermissionMessage::new);
        INSTANCE.registerMessage(CEditConnectionsMessage.class, CEditConnectionsMessage::new);
        INSTANCE.registerMessage(CConnectionUpdateMessage.class, CConnectionUpdateMessage::new);
        INSTANCE.registerMessage(SConnectionUpdateMessage.class, SConnectionUpdateMessage::new);
        INSTANCE.registerMessage(CConfiguratorConnectMessage.class, CConfiguratorConnectMessage::new);
        INSTANCE.registerMessage(CConfiguratorSettingMessage.class, CConfiguratorSettingMessage::new);
    }

    public String getProtocolVersion() {
        return this.protocol;
    }

    public boolean verifyServerProtocol(@Nonnull String serverProtocol) {
        return serverProtocol.equals(this.protocol);
    }

    public boolean verifyClientProtocol(@Nonnull String clientProtocol) {
        return clientProtocol.equals(this.protocol) || clientProtocol.equals(NetworkRegistry.ACCEPTVANILLA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <MSG extends IMessage> void registerMessage(@Nonnull Class<MSG> clazz, @Nonnull Supplier<? extends MSG> factory) {
        NetworkHandler networkHandler = this;
        synchronized (networkHandler) {
            if (this.index == 127) {
                throw new IllegalStateException("Maximum index reached when registering message");
            }
            this.indices.put(this.index, factory);
            byte by = this.index;
            this.index = (byte)(by + 1);
            if (this.types.put(clazz, by) != 127) {
                throw new IllegalStateException("Duplicated registration when registering message");
            }
        }
    }

    private void onS2CMessageReceived(NetworkEvent.ServerCustomPayloadEvent event) {
        this.handleMessage(event.getPayload(), event.getSource());
    }

    private void onC2SMessageReceived(NetworkEvent.ClientCustomPayloadEvent event) {
        this.handleMessage(event.getPayload(), event.getSource());
    }

    private void handleMessage(PacketBuffer buffer, Supplier<NetworkEvent.Context> ctx) {
        byte index = buffer.readByte();
        Supplier factory = (Supplier)this.indices.get(index);
        if (factory == null) {
            throw new IllegalStateException("Unregistered message with index: " + index);
        }
        IMessage message = (IMessage)factory.get();
        message.handle(buffer, ctx.get());
        ctx.get().setPacketHandled(true);
    }

    private <MSG extends IMessage> PacketBuffer toBuffer(MSG message) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        Class<?> clazz = message.getClass();
        byte index = this.types.getByte(clazz);
        if (index == 127) {
            throw new IllegalStateException("Unregistered message with type: " + clazz);
        }
        buffer.writeByte((int)index);
        message.encode(buffer);
        return buffer;
    }

    private <MSG extends IMessage> Pair<PacketBuffer, Integer> toBufferPair(MSG message) {
        return Pair.of((Object)this.toBuffer(message), (Object)Integer.MIN_VALUE);
    }

    private <MSG extends IMessage> IPacket<?> toC2SPacket(MSG message) {
        return NetworkDirection.PLAY_TO_SERVER.buildPacket(this.toBufferPair(message), this.network.getChannelName()).getThis();
    }

    private <MSG extends IMessage> IPacket<?> toS2CPacket(MSG message) {
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket(this.toBufferPair(message), this.network.getChannelName()).getThis();
    }

    public <MSG extends IMessage> void reply(MSG message, NetworkEvent.Context context) {
        context.getPacketDispatcher().sendPacket(this.network.getChannelName(), this.toBuffer(message));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <MSG extends IMessage> void sendToServer(MSG message) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection != null) {
            connection.func_147298_b().func_179290_a(this.toC2SPacket(message));
        }
    }

    public <MSG extends IMessage> void sendToPlayer(MSG message, PlayerEntity player) {
        this.sendToPlayer(message, (ServerPlayerEntity)player);
    }

    public <MSG extends IMessage> void sendToPlayer(MSG message, @Nonnull ServerPlayerEntity playerMP) {
        playerMP.field_71135_a.func_147359_a(this.toS2CPacket(message));
    }

    public <MSG extends IMessage> void sendToPlayers(MSG message, @Nonnull Iterable<? extends PlayerEntity> players) {
        IPacket<?> packet = this.toS2CPacket(message);
        for (PlayerEntity playerEntity : players) {
            ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a(packet);
        }
    }

    public <MSG extends IMessage> void sendToAll(MSG message) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148540_a(this.toS2CPacket(message));
    }

    public <MSG extends IMessage> void sendToDimension(MSG message, @Nonnull RegistryKey<World> dimension) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_232642_a_(this.toS2CPacket(message), dimension);
    }

    public <MSG extends IMessage> void sendToRadius(MSG message, @Nullable ServerPlayerEntity excluded, double x, double y, double z, double radius, @Nonnull RegistryKey<World> dimension) {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148543_a((PlayerEntity)excluded, x, y, z, radius, dimension, this.toS2CPacket(message));
    }

    public <MSG extends IMessage> void sendToEntityTracking(MSG message, @Nonnull Entity entity) {
        ((ServerWorld)entity.func_130014_f_()).func_72863_F().func_217218_b(entity, this.toS2CPacket(message));
    }

    public <MSG extends IMessage> void sendToTrackingAndSelf(MSG message, @Nonnull Entity entity) {
        ((ServerWorld)entity.func_130014_f_()).func_72863_F().func_217216_a(entity, this.toS2CPacket(message));
    }

    public <MSG extends IMessage> void sendToChunkTracking(MSG message, @Nonnull Chunk chunk) {
        IPacket<?> packet = this.toS2CPacket(message);
        ((ServerWorld)chunk.func_177412_p()).func_72863_F().field_217237_a.func_219097_a(chunk.func_76632_l(), false).forEach(player -> player.field_71135_a.func_147359_a(packet));
    }
}

