/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.tileentity;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.power.IBigPower;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.FluxLogicType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.client.FluxClientCache;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.misc.ContainerConnector;
import sonar.fluxnetworks.common.misc.FluxUtils;
import sonar.fluxnetworks.common.network.FluxTileMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;
import sonar.fluxnetworks.common.storage.FluxChunkManager;
import sonar.fluxnetworks.common.storage.FluxNetworkData;

public abstract class TileFluxDevice
extends TileEntity
implements IFluxDevice,
ITickableTileEntity,
INamedContainerProvider,
IBigPower {
    private static final int FLAG_LOAD = 64;
    private static final int FLAG_SETTING_CHANGED = 128;
    private static final int FLAG_FORCED_LOADING = 256;
    public final Set<PlayerEntity> playerUsing = new ObjectArraySet();
    private String customName;
    private UUID playerUUID = Util.field_240973_b_;
    private int networkID;
    public int clientColor = 0xB2B2B2;
    protected int priority;
    protected boolean surgeMode;
    private long limit;
    private boolean disableLimit;
    protected int flags;
    private GlobalPos globalPos;
    private IFluxNetwork network = FluxNetworkInvalid.INSTANCE;

    public TileFluxDevice(TileEntityType<? extends TileFluxDevice> tileEntityTypeIn, String customName, long limit) {
        super(tileEntityTypeIn);
        this.customName = customName;
        this.limit = limit;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && (this.flags & 0x40) == 64) {
            this.network.enqueueConnectionRemoval(this, false);
            if (this.isForcedLoading()) {
                FluxChunkManager.removeChunkLoader(this);
            }
            this.flags &= 0xFFFFFFBF;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.field_145850_b.field_72995_K && (this.flags & 0x40) == 64) {
            this.network.enqueueConnectionRemoval(this, true);
            this.flags &= 0xFFFFFFBF;
        }
    }

    public final void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sTick();
        }
    }

    protected void sTick() {
        if (!this.playerUsing.isEmpty()) {
            NetworkHandler.INSTANCE.sendToPlayers(new FluxTileMessage(this, -1), this.playerUsing);
            this.flags &= 0xFFFFFF7F;
        }
        if ((this.flags & 0x40) == 0) {
            if (this.networkID > 0) {
                IFluxNetwork network = FluxNetworkData.getNetwork(this.networkID);
                if (network.isValid() && (!this.getDeviceType().isController() || network.getConnections(FluxLogicType.CONTROLLER).isEmpty())) {
                    network.enqueueConnectionAddition(this);
                } else {
                    this.networkID = -1;
                }
            }
            this.updateTransfers(Direction.values());
            this.flags |= 0x40;
        }
    }

    @Override
    public void onConnect(@Nonnull IFluxNetwork network) {
        this.network = network;
        this.networkID = network.getNetworkID();
        this.sendFullUpdatePacket();
    }

    @Override
    public void onDisconnect() {
        if (this.network.isValid()) {
            this.network = FluxNetworkInvalid.INSTANCE;
            this.networkID = this.network.getNetworkID();
            this.sendFullUpdatePacket();
        }
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Override
    public IFluxNetwork getNetwork() {
        return this.network;
    }

    @Nonnull
    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeCustomNBT(nbt, 11);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, nbt);
    }

    public final void onDataPacket(NetworkManager net, @Nonnull SUpdateTileEntityPacket pkt) {
        this.readCustomNBT(pkt.func_148857_g(), 11);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), -1);
    }

    @Nonnull
    public final CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("clientColor", this.network.getNetworkColor());
        return this.func_189515_b(tag);
    }

    public final void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        this.clientColor = tag.func_74762_e("clientColor");
        this.func_230337_a_(state, tag);
    }

    @Override
    @Nonnull
    public final World getFluxWorld() {
        return this.field_145850_b;
    }

    @Nonnull
    public final CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        this.writeCustomNBT(super.func_189515_b(compound), 1);
        return compound;
    }

    public final void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readCustomNBT(compound, 1);
    }

    @Override
    public void writeCustomNBT(CompoundNBT tag, int type) {
        if (type <= 20) {
            tag.func_74768_a("networkID", this.networkID);
            tag.func_74778_a("customName", this.customName);
            tag.func_74768_a("priority", this.priority);
            tag.func_74772_a("limit", this.limit);
            tag.func_74757_a("surgeMode", this.surgeMode);
            tag.func_74757_a("disableLimit", this.disableLimit);
        }
        if (type <= 11) {
            tag.func_186854_a("playerUUID", this.playerUUID);
        }
        if (type == 11) {
            tag.func_74768_a("clientColor", this.network.getNetworkColor());
            tag.func_74768_a("flags", this.flags);
        }
        if (type == 20) {
            FluxUtils.writeGlobalPos(tag, this.globalPos);
            tag.func_74774_a("deviceType", (byte)this.getDeviceType().ordinal());
            tag.func_186854_a("playerUUID", this.playerUUID);
            tag.func_74757_a("forcedLoading", this.isForcedLoading());
            tag.func_74757_a("chunkLoaded", this.isChunkLoaded());
            this.getDisplayStack().func_77955_b(tag);
        }
        this.getTransferHandler().writeCustomNBT(tag, type);
    }

    @Override
    public void readCustomNBT(CompoundNBT tag, int type) {
        if (type <= 15) {
            this.networkID = tag.func_74762_e("networkID");
            this.customName = tag.func_74779_i("customName");
            this.setPriority(tag.func_74762_e("priority"));
            this.setTransferLimit(tag.func_74763_f("limit"));
            this.surgeMode = tag.func_74767_n("surgeMode");
            this.disableLimit = tag.func_74767_n("disableLimit");
        }
        if (type <= 11) {
            this.playerUUID = tag.func_186857_a("playerUUID");
        }
        if (type == 11) {
            this.clientColor = tag.func_74762_e("clientColor");
            this.flags = tag.func_74762_e("flags");
        }
        if (type == 15 && this.field_145850_b.field_72995_K) {
            this.clientColor = FluxClientCache.getNetwork(this.networkID).getNetworkColor();
        }
        this.getTransferHandler().readCustomNBT(tag, type);
    }

    @Override
    public boolean canPlayerAccess(@Nonnull PlayerEntity player) {
        if (this.network.isValid()) {
            if (PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).equals(this.playerUUID)) {
                return true;
            }
            return this.network.getPlayerAccess(player).canUse();
        }
        return true;
    }

    public void sendFullUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), -1);
        }
    }

    public void writePacket(PacketBuffer buffer, byte id) {
        this.getTransferHandler().writePacket(buffer, id);
        switch (id) {
            case 1: {
                buffer.func_211400_a(this.customName, 256);
                break;
            }
            case 2: {
                buffer.writeInt(this.priority);
                break;
            }
            case 3: {
                buffer.writeLong(this.limit);
                break;
            }
            case 4: {
                buffer.writeBoolean(this.surgeMode);
                break;
            }
            case 5: {
                buffer.writeBoolean(this.disableLimit);
                break;
            }
            case 6: {
                buffer.writeBoolean(this.isForcedLoading());
                break;
            }
            case -1: {
                buffer.writeBoolean((this.flags & 0x80) == 128);
                if ((this.flags & 0x80) != 128) break;
                buffer.func_211400_a(this.customName, 256);
                buffer.writeInt(this.priority);
                buffer.writeLong(this.limit);
                buffer.writeByte(this.flags >> 6);
            }
        }
    }

    public void readPacket(PacketBuffer buffer, byte id) {
        this.getTransferHandler().readPacket(buffer, id);
        switch (id) {
            case 1: {
                this.customName = buffer.func_150789_c(256);
                break;
            }
            case 2: {
                this.setPriority(buffer.readInt());
                this.network.markSortConnections();
                break;
            }
            case 3: {
                this.setTransferLimit(buffer.readLong());
                break;
            }
            case 4: {
                this.surgeMode = buffer.readBoolean();
                this.network.markSortConnections();
                break;
            }
            case 5: {
                this.disableLimit = buffer.readBoolean();
                break;
            }
            case 6: {
                boolean toLoad = buffer.readBoolean();
                if (FluxConfig.enableChunkLoading && !this.getDeviceType().isStorage()) {
                    if (toLoad && !this.isForcedLoading()) {
                        FluxChunkManager.addChunkLoader(this);
                    } else if (!toLoad && this.isForcedLoading()) {
                        FluxChunkManager.removeChunkLoader(this);
                    }
                    this.setForcedLoading(FluxChunkManager.isChunkLoader(this));
                    break;
                }
                this.setForcedLoading(false);
                break;
            }
            case -1: {
                if (!buffer.readBoolean()) break;
                this.customName = buffer.func_150789_c(256);
                this.priority = buffer.readInt();
                this.limit = buffer.readLong();
                this.flags = this.flags & 0x3F | buffer.readByte() << 6;
            }
        }
        if (id > 0) {
            this.flags |= 0x80;
        }
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID;
    }

    public final void setConnectionOwner(UUID uuid) {
        this.playerUUID = uuid;
    }

    public void updateTransfers(Direction ... dirs) {
        this.getTransferHandler().updateTransfers(dirs);
    }

    @Override
    public void onContainerOpened(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.add(player);
            this.sendFullUpdatePacket();
        }
    }

    @Override
    public void onContainerClosed(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playerUsing.remove(player);
        }
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public boolean isChunkLoaded() {
        return !this.func_145837_r();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isForcedLoading() {
        return (this.flags & 0x100) == 256;
    }

    @Override
    public void setForcedLoading(boolean forcedLoading) {
        this.flags = forcedLoading ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    @Override
    public final int getRawPriority() {
        return this.priority;
    }

    @Override
    public int getLogicPriority() {
        return this.surgeMode ? Integer.MAX_VALUE : this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = MathHelper.func_76125_a((int)priority, (int)-9999, (int)0x7FFFFFFE);
    }

    @Override
    public final long getRawLimit() {
        return this.limit;
    }

    @Override
    public final long getLogicLimit() {
        return this.disableLimit ? this.getMaxTransferLimit() : this.limit;
    }

    @Override
    public final void setTransferLimit(long limit) {
        this.limit = Math.min(limit, this.getMaxTransferLimit());
    }

    @Override
    public long getMaxTransferLimit() {
        return Long.MAX_VALUE;
    }

    @Override
    public final long getTransferBuffer() {
        return this.getTransferHandler().getBuffer();
    }

    @Override
    public final long getTransferChange() {
        return this.getTransferHandler().getChange();
    }

    @Override
    @Nonnull
    public final GlobalPos getGlobalPos() {
        if (this.globalPos == null) {
            this.globalPos = FluxUtils.getGlobalPos(this);
        }
        return this.globalPos;
    }

    @Override
    public final boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public final void setDisableLimit(boolean disableLimit) {
        this.disableLimit = disableLimit;
    }

    @Override
    public final boolean getSurgeMode() {
        return this.surgeMode;
    }

    @Override
    public final void setSurgeMode(boolean surgeMode) {
        this.surgeMode = surgeMode;
    }

    @Override
    public final long getStoredPower() {
        return this.getTransferBuffer();
    }

    @Override
    public final long getCapacity() {
        return this.getMaxTransferLimit();
    }

    @Nonnull
    public final ITextComponent func_145748_c_() {
        return StringTextComponent.field_240750_d_;
    }

    @Nullable
    public final Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity entity) {
        return new ContainerConnector<TileFluxDevice>(windowID, playerInventory, this);
    }
}

