/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.INetworkConnector;
import sonar.fluxnetworks.client.FluxColorHandler;
import sonar.fluxnetworks.client.gui.GuiFluxAdminHome;
import sonar.fluxnetworks.client.gui.GuiFluxConfiguratorHome;
import sonar.fluxnetworks.client.gui.GuiFluxDeviceHome;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.mui.MUIIntegration;
import sonar.fluxnetworks.client.render.FluxStorageTileRenderer;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.item.ItemFluxConfigurator;
import sonar.fluxnetworks.common.misc.ContainerConnector;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;
import sonar.fluxnetworks.common.tileentity.TileFluxDevice;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="fluxnetworks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistration {
    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.BASIC_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.HERCULEAN_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(RegistryBlocks.GARGANTUAN_FLUX_STORAGE_TILE, FluxStorageTileRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_PLUG, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_POINT, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.FLUX_CONTROLLER, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.BASIC_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE, (RenderType)RenderType.func_228643_e_());
        if (FluxConfig.enableGuiDebug && FluxNetworks.modernUILoaded) {
            MUIIntegration.init();
        } else {
            ScreenManager.func_216911_a(RegistryBlocks.CONTAINER_CONNECTOR, ClientRegistration.getScreenFactory());
        }
        FluxNetworks.LOGGER.info("Finished Client Setup Event");
    }

    @Nonnull
    private static ScreenManager.IScreenFactory<ContainerConnector<?>, GuiTabCore> getScreenFactory() {
        return (container, inventory, windowID) -> {
            if (container == null) {
                return null;
            }
            Object connector = container.connector;
            if (connector instanceof TileFluxDevice) {
                return new GuiFluxDeviceHome(inventory.field_70458_d, (TileFluxDevice)connector);
            }
            if (connector instanceof ItemFluxConfigurator.NetworkConnector) {
                return new GuiFluxConfiguratorHome(inventory.field_70458_d, (ItemFluxConfigurator.NetworkConnector)connector);
            }
            if (connector instanceof ItemAdminConfigurator.NetworkConnector) {
                return new GuiFluxAdminHome(inventory.field_70458_d, (INetworkConnector)connector);
            }
            return null;
        };
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(@Nonnull ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((IItemColor)FluxColorHandler.INSTANCE, new IItemProvider[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG});
        event.getItemColors().func_199877_a(FluxColorHandler::colorMultiplierForConfigurator, new IItemProvider[]{RegistryItems.FLUX_CONFIGURATOR});
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(@Nonnull ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)FluxColorHandler.INSTANCE, new Block[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG, RegistryBlocks.BASIC_FLUX_STORAGE, RegistryBlocks.HERCULEAN_FLUX_STORAGE, RegistryBlocks.GARGANTUAN_FLUX_STORAGE});
    }
}

