/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.button.NormalButton;
import sonar.fluxnetworks.client.gui.button.SlidedSwitchButton;
import sonar.fluxnetworks.common.misc.FluxMenu;

public abstract class PopupCore<T extends GuiFluxCore>
extends GuiFocusable<FluxMenu> {
    protected List<NormalButton> popButtons = new ArrayList<NormalButton>();
    protected List<SlidedSwitchButton> popSwitches = new ArrayList<SlidedSwitchButton>();
    public final T host;
    public final PlayerEntity player;
    private float alpha = 0.0f;

    public PopupCore(@Nonnull T host, PlayerEntity player) {
        super(host.func_212873_a_(), player);
        this.host = host;
        this.player = player;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.popButtons.clear();
        this.popSwitches.clear();
    }

    public void openPopUp() {
        super.func_231158_b_(Minecraft.func_71410_x(), ((GuiFluxCore)((Object)this.host)).field_230708_k_, ((GuiFluxCore)((Object)this.host)).field_230709_l_);
    }

    public void closePopUp() {
        this.popButtons.clear();
        this.popSwitches.clear();
    }

    public final void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        throw new UnsupportedOperationException();
    }

    public void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        this.popButtons.forEach(b -> b.drawButton(this.field_230706_i_, matrixStack, mouseX, mouseY, this.field_147003_i, this.field_147009_r));
    }

    public void func_230450_a_(@Nonnull MatrixStack matrixStack, float deltaTicks, int mouseX, int mouseY) {
        this.alpha = Math.min(1.0f, this.alpha + deltaTicks * 0.25f);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.BACKGROUND);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 128, this.field_230709_l_ / 2 - 128, 0, 0, 256, 256);
        this.screenUtils.setGuiColoring(((GuiFluxCore)((Object)this.host)).network.getNetworkColor(), this.alpha);
        this.field_230706_i_.func_110434_K().func_110577_a(ScreenUtils.FRAME);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 128, this.field_230709_l_ / 2 - 128, 0, 0, 256, 256);
        int bgColor = (int)(this.alpha * 64.0f) << 24;
        PopupCore.func_238467_a_((MatrixStack)matrixStack, (int)(-this.field_147003_i), (int)(-this.field_147009_r), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)bgColor);
        for (SlidedSwitchButton button : this.popSwitches) {
            button.updateButton(deltaTicks, mouseX, mouseY);
        }
        for (Widget widget : this.field_230710_m_) {
            widget.func_230430_a_(matrixStack, mouseX, mouseY, deltaTicks);
        }
    }
}

