/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.tab;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TextFormatting;
import sonar.fluxnetworks.api.gui.EnumNavigationTab;
import sonar.fluxnetworks.api.misc.EnergyType;
import sonar.fluxnetworks.api.text.FluxTranslate;
import sonar.fluxnetworks.client.gui.LineChart;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.InvisibleButton;
import sonar.fluxnetworks.common.connection.NetworkStatistics;
import sonar.fluxnetworks.common.misc.FluxMenu;
import sonar.fluxnetworks.common.network.CNetworkUpdateMessage;
import sonar.fluxnetworks.common.network.NetworkHandler;

public class GuiTabStatistics
extends GuiTabCore {
    public InvisibleButton redirectButton;
    private final NetworkStatistics stats;
    private LineChart chart;
    private int timer;

    public GuiTabStatistics(@Nonnull FluxMenu container, @Nonnull PlayerEntity player) {
        super(container, player);
        this.stats = this.network.getStatistics();
        this.timer = 0;
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_STATISTICS;
    }

    @Override
    protected void drawForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(matrixStack, mouseX, mouseY);
        if (this.networkValid) {
            int color = this.network.getNetworkColor();
            this.screenUtils.renderNetwork(matrixStack, this.network.getNetworkName(), color, 20, 8);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.PLUGS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPlugCount, 12.0f, 24.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.POINTS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPointCount, 12.0f, 36.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.STORAGES.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxStorageCount, 82.0f, 24.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.CONTROLLERS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxControllerCount, 82.0f, 36.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.INPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + EnergyType.usageCompact(this.stats.energyInput), 12.0f, 48.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.OUTPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + EnergyType.usageCompact(this.stats.energyOutput), 12.0f, 60.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.BUFFER.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + EnergyType.storageCompact(this.stats.totalBuffer), 12.0f, 72.0f, color);
            this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.GRAY + FluxTranslate.ENERGY.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + EnergyType.storageCompact(this.stats.totalEnergy), 12.0f, 84.0f, color);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.75f, 0.75f, 1.0f);
            this.drawCenterText(matrixStack, FluxTranslate.AVERAGE_TICK.t() + ": " + this.stats.averageTickMicro + " \u00b5s/t", (float)this.field_146999_f / 2.0f * 1.3333334f, ((float)this.field_147000_g - 2.0f) * 1.3333334f, color);
            matrixStack.func_227865_b_();
        } else {
            this.renderNavigationPrompt(matrixStack, FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
            this.redirectButton = new InvisibleButton(this.field_147003_i + 20, this.field_147009_r + 16, 135, 20, EnumNavigationTab.TAB_SELECTION.getTranslatedName(), b -> this.switchTab(EnumNavigationTab.TAB_SELECTION));
            this.func_230480_a_((Widget)this.redirectButton);
        }
    }

    @Override
    protected void drawBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        if (this.networkValid && this.chart != null) {
            this.chart.drawChart(this.field_230706_i_, matrixStack, partialTicks);
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.configureNavigationButtons(EnumNavigationTab.TAB_STATISTICS, this.navigationTabs);
        if (this.networkValid) {
            this.chart = new LineChart(this.field_230708_k_ / 2 - 48, this.field_230709_l_ / 2 + 20, 50, 6, "s", EnergyType.FE.getStorageSuffix());
            this.chart.updateData(this.stats.energyChange);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.networkValid) {
            if (this.timer == 0) {
                NetworkHandler.INSTANCE.sendToServer(new CNetworkUpdateMessage(this.network.getNetworkID(), 24));
            }
            if (this.timer == 1) {
                this.chart.updateData(this.stats.energyChange);
            }
            ++this.timer;
            this.timer %= 20;
        }
    }
}

