/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.energy.IItemEnergyHandler;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.common.connection.transfer.BasicPointHandler;
import sonar.fluxnetworks.common.integration.CuriosIntegration;
import sonar.fluxnetworks.common.misc.EnergyUtils;
import sonar.fluxnetworks.common.tileentity.TileFluxController;

public class FluxControllerHandler
extends BasicPointHandler<TileFluxController> {
    private static final Set<ServerPlayerEntity> CHARGING_PLAYERS = new ObjectOpenHashSet();
    private static final Predicate<ItemStack> NOT_EMPTY = s -> !s.func_190926_b();
    private final Map<ServerPlayerEntity, Iterable<WirelessHandler>> players = new HashMap<ServerPlayerEntity, Iterable<WirelessHandler>>();
    private int timer;

    public FluxControllerHandler(TileFluxController fluxController) {
        super(fluxController);
    }

    @Override
    public void onCycleStart() {
        if (!((TileFluxController)this.device).isActive() || !WirelessType.ENABLE_WIRELESS.isActivated(((TileFluxController)this.device).getNetwork())) {
            this.demand = 0L;
            this.clearPlayers();
            return;
        }
        if (this.timer == 0) {
            this.updatePlayers();
        }
        if ((this.timer & 3) == 2) {
            this.demand = this.chargeAllItems(((TileFluxController)this.device).getLogicLimit(), true);
        }
    }

    @Override
    public void onCycleEnd() {
        super.onCycleEnd();
        ++this.timer;
        this.timer &= 0x1F;
    }

    @Override
    public void updateTransfers(Direction ... faces) {
    }

    @Override
    public void reset() {
        super.reset();
        this.clearPlayers();
    }

    @Override
    public long sendToConsumers(long energy, boolean simulate) {
        if (!((TileFluxController)this.device).isActive()) {
            return 0L;
        }
        if ((this.timer & 3) > 0) {
            return 0L;
        }
        if (!WirelessType.ENABLE_WIRELESS.isActivated(((TileFluxController)this.device).getNetwork())) {
            return 0L;
        }
        return this.chargeAllItems(energy, simulate);
    }

    private long chargeAllItems(long energy, boolean simulate) {
        long leftover = energy;
        for (Map.Entry<ServerPlayerEntity, Iterable<WirelessHandler>> player : this.players.entrySet()) {
            if (!player.getKey().func_70089_S()) continue;
            for (WirelessHandler handler : player.getValue()) {
                leftover = handler.chargeItems(leftover, simulate);
                if (leftover > 0L) continue;
                return energy;
            }
        }
        return energy - leftover;
    }

    private void clearPlayers() {
        if (!this.players.isEmpty()) {
            for (ServerPlayerEntity toRemove : this.players.keySet()) {
                CHARGING_PLAYERS.remove(toRemove);
            }
            this.players.clear();
        }
    }

    private void updatePlayers() {
        this.clearPlayers();
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        int wireless = ((TileFluxController)this.device).getNetwork().getWirelessMode();
        for (NetworkMember p : ((TileFluxController)this.device).getNetwork().getAllMembers()) {
            ServerPlayerEntity player = playerList.func_177451_a(p.getPlayerUUID());
            if (player == null || CHARGING_PLAYERS.contains(player)) continue;
            final PlayerInventory inv = player.field_71071_by;
            ArrayList<WirelessHandler> handlers = new ArrayList<WirelessHandler>();
            if (WirelessType.MAIN_HAND.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> new Iterator<ItemStack>(){
                    private byte count;

                    @Override
                    public boolean hasNext() {
                        return this.count < 1;
                    }

                    @Override
                    public ItemStack next() {
                        this.count = (byte)(this.count + 1);
                        return inv.func_70448_g();
                    }
                }, NOT_EMPTY));
            }
            if (WirelessType.OFF_HAND.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> inv.field_184439_c.iterator(), NOT_EMPTY));
            }
            if (WirelessType.HOT_BAR.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> inv.field_70462_a.subList(0, 9).iterator(), stack -> {
                    ItemStack heldItem = inv.func_70448_g();
                    return !stack.func_190926_b() && (heldItem.func_190926_b() || heldItem != stack);
                }));
            }
            if (WirelessType.ARMOR.isActivated(wireless)) {
                handlers.add(new WirelessHandler(() -> inv.field_70460_b.iterator(), NOT_EMPTY));
            }
            if (WirelessType.CURIOS.isActivated(wireless) && FluxNetworks.curiosLoaded) {
                final LazyOptional<IItemHandlerModifiable> curios = CuriosIntegration.getEquippedCurios(player);
                handlers.add(new WirelessHandler(() -> {
                    if (curios.isPresent()) {
                        return new Iterator<ItemStack>(){
                            private final IItemHandler handler;
                            private int count;
                            {
                                this.handler = (IItemHandler)curios.orElseThrow(IllegalStateException::new);
                            }

                            @Override
                            public boolean hasNext() {
                                return this.count < this.handler.getSlots();
                            }

                            @Override
                            public ItemStack next() {
                                ItemStack next = this.handler.getStackInSlot(this.count);
                                ++this.count;
                                return next;
                            }
                        };
                    }
                    return null;
                }, NOT_EMPTY));
            }
            this.players.put(player, handlers);
            CHARGING_PLAYERS.add(player);
        }
    }

    private static class WirelessHandler {
        private final Supplier<Iterator<ItemStack>> supplier;
        private final Predicate<ItemStack> validator;

        WirelessHandler(Supplier<Iterator<ItemStack>> supplier, Predicate<ItemStack> validator) {
            this.supplier = supplier;
            this.validator = validator;
        }

        private long chargeItems(long leftover, boolean simulate) {
            Iterator<ItemStack> it = this.supplier.get();
            while (it != null && it.hasNext()) {
                IItemEnergyHandler handler;
                ItemStack stack = it.next();
                if (!this.validator.test(stack) || (handler = EnergyUtils.getEnergyHandler(stack)) == null || !handler.canAddEnergy(stack) || (leftover -= handler.addEnergy(leftover, stack, simulate)) > 0L) continue;
                return 0L;
            }
            return leftover;
        }
    }
}

