/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import sonar.fluxnetworks.api.misc.IMessage;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.client.FluxClientCache;

public class SNetworkUpdateMessage
implements IMessage {
    private final Int2ObjectMap<CompoundNBT> updatedNetworks = new Int2ObjectArrayMap();
    private int type;

    public SNetworkUpdateMessage() {
    }

    public SNetworkUpdateMessage(@Nonnull IFluxNetwork toSend, int type) {
        this.type = type;
        CompoundNBT tag = new CompoundNBT();
        toSend.writeCustomNBT(tag, type);
        if (!tag.isEmpty()) {
            this.updatedNetworks.put(toSend.getNetworkID(), (Object)tag);
        }
    }

    public SNetworkUpdateMessage(@Nonnull Collection<IFluxNetwork> toSend, int type) {
        this.type = type;
        toSend.forEach(network -> {
            CompoundNBT tag = new CompoundNBT();
            network.writeCustomNBT(tag, type);
            if (!tag.isEmpty()) {
                this.updatedNetworks.put(network.getNetworkID(), (Object)tag);
            }
        });
    }

    @Override
    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(this.type);
        Int2ObjectMap<CompoundNBT> updatedNetworks = this.updatedNetworks;
        buffer.func_150787_b(updatedNetworks.size());
        updatedNetworks.forEach((i, n) -> {
            buffer.func_150787_b(i.intValue());
            buffer.func_150786_a(n);
        });
    }

    @Override
    public void handle(@Nonnull PacketBuffer buffer, @Nonnull NetworkEvent.Context context) {
        int type = buffer.func_150792_a();
        Int2ObjectMap<CompoundNBT> updatedNetworks = this.updatedNetworks;
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            updatedNetworks.put(buffer.func_150792_a(), (Object)buffer.func_150793_b());
        }
        FluxClientCache.updateNetworks(updatedNetworks, type);
        buffer.release();
    }
}

