/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.common.base.Charsets;
import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.forgemod.ForgeModVoxelMap;
import com.mamiyaotaru.voxelmap.forgemod.WorldIDPacket;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class VoxelMap
extends AbstractVoxelMap
implements IFutureReloadListener {
    private MapSettingsManager mapOptions = null;
    private RadarSettingsManager radarOptions = null;
    private PersistentMapSettingsManager persistentMapOptions = null;
    private IMap map = null;
    private IRadar radar = null;
    private IRadar radarSimple = null;
    private PersistentMap persistentMap = null;
    private ISettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier = null;
    private WorldUpdateListener worldUpdateListener = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private IDimensionManager dimensionManager = null;
    private ClientWorld world;
    private String worldName = "";
    private Long newServerTime = 0L;
    private boolean checkMOTD = false;
    private ChatLine<ITextComponent> mostRecentLine = null;
    private UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
    private String passMessage = null;

    public VoxelMap() {
        instance = this;
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        GLUtils.textureManager = Minecraft.func_71410_x().func_110434_K();
        this.mapOptions = new MapSettingsManager();
        this.mapOptions.showUnderMenus = showUnderMenus;
        this.radarOptions = new RadarSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.persistentMap = new PersistentMap(this);
        this.mapOptions.loadAll();
        try {
            if (isFair) {
                this.radarOptions.radarAllowed = false;
                this.radarOptions.radarMobsAllowed = false;
                this.radarOptions.radarPlayersAllowed = false;
            } else {
                this.radarOptions.radarAllowed = true;
                this.radarOptions.radarMobsAllowed = true;
                this.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar(this);
                this.radarSimple = new RadarSimple(this);
            }
        }
        catch (Exception e) {
            this.radarOptions.radarAllowed = false;
            this.radarOptions.radarMobsAllowed = false;
            this.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        this.map = new Map(this);
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        resourceManager.func_219534_a((IFutureReloadListener)this);
        this.apply((IResourceManager)resourceManager);
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage synchronizer, IResourceManager resourceManager, IProfiler loadProfiler, IProfiler applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return synchronizer.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> this.apply(resourceManager), applyExecutor);
    }

    private CompletableFuture<Void> apply(IResourceManager resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
        return null;
    }

    public void onTickInGame(MatrixStack matrixStack, Minecraft mc) {
        this.map.onTickInGame(matrixStack, mc);
        if (this.passMessage != null) {
            mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(this.passMessage));
            this.passMessage = null;
        }
    }

    public void onTick(Minecraft mc, boolean clock) {
        if (this.checkMOTD) {
            this.checkPermissionMessages(mc);
        }
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world) || this.world != null && !this.world.equals(GameVariableAccessShim.getWorld())) {
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld((World)this.world);
            this.persistentMap.newWorld(this.world);
            if (this.world != null) {
                MapUtils.reset();
                StringBuilder channelList = new StringBuilder();
                channelList.append("worldinfo:world_id");
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBytes(channelList.toString().getBytes(Charsets.UTF_8));
                mc.func_147114_u().func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("register"), buffer));
                ForgeModVoxelMap.WORLD_ID.sendToServer((Object)new WorldIDPacket());
                mc.field_71439_g.func_110306_p();
                java.util.Map skinMap = mc.func_152342_ad().func_152788_a(mc.field_71439_g.func_146103_bH());
                if (skinMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)skinMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                if (!this.worldName.equals(this.waypointManager.getCurrentWorldName())) {
                    this.worldName = this.waypointManager.getCurrentWorldName();
                    this.radarOptions.radarPlayersAllowed = this.radarOptions.radarAllowed = Boolean.valueOf(true);
                    this.radarOptions.radarMobsAllowed = this.radarOptions.radarAllowed;
                    this.mapOptions.cavesAllowed = true;
                    if (!mc.func_71387_A()) {
                        this.newServerTime = System.currentTimeMillis();
                        this.checkMOTD = true;
                    }
                }
                this.map.newWorld(this.world);
            }
        }
        TickCounter.onTick(clock);
        this.persistentMap.onTick(mc);
    }

    private void checkPermissionMessages(Minecraft mc) {
        if (GameVariableAccessShim.getWorld() != null && mc.field_71439_g != null && mc.field_71456_v != null && System.currentTimeMillis() - this.newServerTime < 5000L) {
            UUID playerUUID = mc.field_71439_g.func_110124_au();
            NewChatGui guiNewChat = mc.field_71456_v.func_146158_b();
            if (guiNewChat == null) {
                System.out.println("failed to get guiNewChat");
            } else {
                Object chatListObj = ReflectionUtils.getPrivateFieldValueByType(guiNewChat, NewChatGui.class, List.class, 1);
                if (chatListObj == null) {
                    System.out.println("could not get chatlist");
                } else {
                    ChatLine checkMe;
                    List chatList = (List)chatListObj;
                    boolean killRadar = false;
                    boolean killCaves = false;
                    for (int t = 0; t < chatList.size() && !(checkMe = (ChatLine)chatList.get(t)).equals(this.mostRecentLine); ++t) {
                        ITextComponent rawText = (ITextComponent)checkMe.func_238169_a_();
                        String msg = TextUtils.getFormattedText(rawText);
                        String error = "";
                        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) {
                            killCaves = true;
                            error = error + "Server disabled cavemapping.  ";
                        }
                        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
                            killRadar = true;
                            error = error + "Server disabled radar.  ";
                        }
                        if (error.equals("")) continue;
                        this.passMessage = error;
                    }
                    this.radarOptions.radarPlayersAllowed = this.radarOptions.radarAllowed = Boolean.valueOf(this.radarOptions.radarAllowed != false && (!killRadar || this.devUUID.equals(playerUUID)));
                    this.radarOptions.radarMobsAllowed = this.radarOptions.radarAllowed;
                    this.mapOptions.cavesAllowed = this.mapOptions.cavesAllowed != false && (!killCaves || this.devUUID.equals(playerUUID));
                    this.mostRecentLine = chatList.size() > 0 ? (ChatLine)chatList.get(0) : null;
                }
            }
        } else {
            this.checkMOTD = false;
        }
    }

    public void setConnectedRealm(String id) {
        this.waypointManager.setConnectedRealm(id);
    }

    @Override
    public MapSettingsManager getMapOptions() {
        return this.mapOptions;
    }

    @Override
    public RadarSettingsManager getRadarOptions() {
        return this.radarOptions;
    }

    @Override
    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    @Override
    public IRadar getRadar() {
        if (this.radarOptions.showRadar) {
            if (this.radarOptions.radarMode == this.radarOptions.SIMPLE) {
                return this.radarSimple;
            }
            if (this.radarOptions.radarMode == this.radarOptions.FULL) {
                return this.radar;
            }
        }
        return null;
    }

    @Override
    public IColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public IDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    public IPersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    @Override
    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        boolean override = false;
        try {
            UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
            UUID playerUUID = Minecraft.func_71410_x().field_71439_g.func_110124_au();
            override = playerUUID.equals(devUUID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.radarOptions.radarAllowed = hasFullRadarPermission || override;
        this.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission || override;
        this.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission || override;
        this.mapOptions.cavesAllowed = hasCavemodePermission || override;
    }

    @Override
    public synchronized void newSubWorldName(String name, boolean fromServer) {
        this.waypointManager.setSubworldName(name, fromServer);
        this.map.newWorldName();
    }

    @Override
    public synchronized void newSubWorldHash(String hash) {
        this.waypointManager.setSubworldHash(hash);
    }

    @Override
    public String getWorldSeed() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            String seed = "";
            try {
                seed = Long.toString(Minecraft.func_71410_x().func_71401_C().func_71218_a(World.field_234918_g_).func_72905_C());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return seed;
        }
        return this.waypointManager.getWorldSeed();
    }

    @Override
    public void setWorldSeed(String newSeed) {
        if (!Minecraft.func_71410_x().func_71387_A()) {
            this.waypointManager.setWorldSeed(newSeed);
        }
    }

    @Override
    public void sendPlayerMessageOnMainThread(String s) {
        this.passMessage = s;
    }

    @Override
    public WorldUpdateListener getWorldUpdateListener() {
        return this.worldUpdateListener;
    }
}

