/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.forgemod;

import java.nio.charset.StandardCharsets;
import net.minecraft.network.PacketBuffer;

public class WorldIDPacket {
    private String worldID;

    public WorldIDPacket() {
        this.worldID = "";
    }

    public WorldIDPacket(String worldID) {
        this.worldID = worldID;
    }

    public String getWorldID() {
        return this.worldID;
    }

    public static void encode(WorldIDPacket packet, PacketBuffer buf) {
        System.out.println("encoding id packet");
        buf.writeByte(42);
        buf.func_180714_a(packet.worldID);
    }

    public static WorldIDPacket decode(PacketBuffer buffer) {
        String subWorldName = "";
        try {
            byte id = buffer.readByte();
            byte length = buffer.readByte();
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            subWorldName = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            subWorldName = "";
            System.err.println(String.format("Failed to read message: %s", e));
        }
        return new WorldIDPacket(subWorldName);
    }
}

