/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSlotDimensions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GuiAddWaypoint
extends GuiScreenMinimap
implements IPopupGuiScreen {
    IVoxelMap master;
    IWaypointManager waypointManager;
    IColorManager colorManager;
    private IGuiWaypoints parentGui;
    private PopupGuiButton doneButton;
    private GuiSlotDimensions dimensionList;
    protected DimensionContainer selectedDimension = null;
    private ITextComponent tooltip = null;
    private TextFieldWidget waypointName;
    private TextFieldWidget waypointX;
    private TextFieldWidget waypointZ;
    private TextFieldWidget waypointY;
    private PopupGuiButton buttonEnabled;
    protected Waypoint waypoint;
    private boolean choosingColor = false;
    private boolean choosingIcon = false;
    private float red;
    private float green;
    private float blue;
    private String suffix;
    private boolean enabled;
    private boolean editing = false;
    private final ResourceLocation pickerResourceLocation = new ResourceLocation("voxelmap", "images/colorpicker.png");

    public GuiAddWaypoint(IGuiWaypoints par1GuiScreen, IVoxelMap master, Waypoint par2Waypoint, boolean editing) {
        this.master = master;
        this.waypointManager = master.getWaypointManager();
        this.colorManager = master.getColorManager();
        this.parentGui = par1GuiScreen;
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.suffix = this.waypoint.imageSuffix;
        this.enabled = this.waypoint.enabled;
        this.editing = editing;
    }

    public void func_231023_e_() {
        this.waypointName.func_146178_a();
        this.waypointX.func_146178_a();
        this.waypointY.func_146178_a();
        this.waypointZ.func_146178_a();
    }

    public void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.getButtonList().clear();
        this.waypointName = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20, null);
        this.waypointName.func_146180_a(this.waypoint.name);
        this.waypointX = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointX.func_146203_f(128);
        this.waypointX.func_146180_a("" + this.waypoint.getX());
        this.waypointZ = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointZ.func_146203_f(128);
        this.waypointZ.func_146180_a("" + this.waypoint.getZ());
        this.waypointY = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointY.func_146203_f(128);
        this.waypointY.func_146180_a("" + this.waypoint.getY());
        this.func_230480_a_((Widget)this.waypointName);
        this.func_230480_a_((Widget)this.waypointX);
        this.func_230480_a_((Widget)this.waypointZ);
        this.func_230480_a_((Widget)this.waypointY);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.buttonEnabled = new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 0, 100, 20, (ITextComponent)new StringTextComponent("Enabled: " + (this.waypoint.enabled ? "On" : "Off")), button -> {
            this.waypoint.enabled = !this.waypoint.enabled;
        }, this);
        this.func_230480_a_((Widget)this.buttonEnabled);
        this.func_230480_a_((Widget)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 24, 100, 20, (ITextComponent)new StringTextComponent(I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + ":     "), button -> {
            this.choosingColor = true;
        }, this));
        this.func_230480_a_((Widget)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 48, 100, 20, (ITextComponent)new StringTextComponent(I18nUtils.getString("minimap.waypoints.sortbyicon", new Object[0]) + ":     "), button -> {
            this.choosingIcon = true;
        }, this));
        this.doneButton = new PopupGuiButton(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, (ITextComponent)new TranslationTextComponent("addServer.add"), button -> this.acceptWaypoint(), this);
        this.func_230480_a_((Widget)this.doneButton);
        this.func_230480_a_((Widget)new PopupGuiButton(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.cancelWaypoint(), this));
        this.doneButton.field_230693_o_ = this.waypointName.func_146179_b().length() > 0;
        this.func_231035_a_((IGuiEventListener)this.waypointName);
        this.waypointName.func_146195_b(true);
        this.dimensionList = new GuiSlotDimensions(this);
    }

    @Override
    public void func_231164_f_() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    protected void cancelWaypoint() {
        this.waypoint.red = this.red;
        this.waypoint.green = this.green;
        this.waypoint.blue = this.blue;
        this.waypoint.imageSuffix = this.suffix;
        this.waypoint.enabled = this.enabled;
        if (this.parentGui != null) {
            this.parentGui.accept(false);
        } else {
            this.getMinecraft().func_147108_a(null);
        }
    }

    protected void acceptWaypoint() {
        this.waypoint.name = this.waypointName.func_146179_b();
        this.waypoint.setX(Integer.parseInt(this.waypointX.func_146179_b()));
        this.waypoint.setZ(Integer.parseInt(this.waypointZ.func_146179_b()));
        this.waypoint.setY(Integer.parseInt(this.waypointY.func_146179_b()));
        if (this.parentGui != null) {
            this.parentGui.accept(true);
        } else {
            if (this.editing) {
                this.waypointManager.saveWaypoints();
            } else {
                this.waypointManager.addWaypoint(this.waypoint);
            }
            this.getMinecraft().func_147108_a(null);
        }
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.func_231046_a_(keysm, scancode, b);
            boolean acceptable = this.waypointName.func_146179_b().length() > 0;
            try {
                Integer.parseInt(this.waypointX.func_146179_b());
                Integer.parseInt(this.waypointZ.func_146179_b());
                Integer.parseInt(this.waypointY.func_146179_b());
            }
            catch (NumberFormatException e) {
                acceptable = false;
            }
            this.doneButton.field_230693_o_ = acceptable;
            if ((keysm == 257 || keysm == 335) && acceptable) {
                this.acceptWaypoint();
            }
        }
        return OK;
    }

    public boolean func_231042_a_(char character, int keycode) {
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.func_231042_a_(character, keycode);
            boolean acceptable = this.waypointName.func_146179_b().length() > 0;
            try {
                Integer.parseInt(this.waypointX.func_146179_b());
                Integer.parseInt(this.waypointZ.func_146179_b());
                Integer.parseInt(this.waypointY.func_146179_b());
            }
            catch (NumberFormatException e) {
                acceptable = false;
            }
            this.doneButton.field_230693_o_ = acceptable;
        }
        return OK;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen()) {
            super.func_231044_a_(mouseX, mouseY, mouseButton);
            this.waypointName.func_231044_a_(mouseX, mouseY, mouseButton);
            this.waypointX.func_231044_a_(mouseX, mouseY, mouseButton);
            this.waypointZ.func_231044_a_(mouseX, mouseY, mouseButton);
            this.waypointY.func_231044_a_(mouseX, mouseY, mouseButton);
        } else if (this.choosingColor) {
            if (mouseX >= (double)(this.getWidth() / 2 - 128) && mouseX < (double)(this.getWidth() / 2 + 128) && mouseY >= (double)(this.getHeight() / 2 - 128) && mouseY < (double)(this.getHeight() / 2 + 128)) {
                int color = this.colorManager.getColorPicker().getRGB((int)mouseX - (this.getWidth() / 2 - 128), (int)mouseY - (this.getHeight() / 2 - 128));
                this.waypoint.red = (float)(color >> 16 & 0xFF) / 255.0f;
                this.waypoint.green = (float)(color >> 8 & 0xFF) / 255.0f;
                this.waypoint.blue = (float)(color >> 0 & 0xFF) / 255.0f;
                this.choosingColor = false;
            }
        } else if (this.choosingIcon) {
            float y;
            float x;
            Sprite icon;
            float adj;
            float scScale = (float)this.getMinecraft().func_228018_at_().func_198100_s();
            TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)this.getMinecraft().func_228018_at_().func_198109_k()) {
                adj = displayWidthFloat / (float)this.getMinecraft().func_228018_at_().func_198109_k();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)this.getMinecraft().func_228018_at_().func_198091_l()) {
                adj = displayHeightFloat / (float)this.getMinecraft().func_228018_at_().func_198091_l();
                scale *= adj;
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            if (mouseX >= (double)(this.getWidth() / 2 - displayWidth / 2) && mouseX < (double)(this.getWidth() / 2 + displayWidth / 2) && mouseY >= (double)(this.getHeight() / 2 - displayHeight / 2) && mouseY < (double)(this.getHeight() / 2 + displayHeight / 2) && (icon = chooser.getIconAt(x = ((float)mouseX - (float)(this.getWidth() / 2 - displayWidth / 2)) * scale, y = ((float)mouseY - (float)(this.getHeight() / 2 - displayHeight / 2)) * scale)) != chooser.getMissingImage()) {
                this.waypoint.imageSuffix = icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
                this.choosingIcon = false;
            }
        }
        if (!this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen() && this.dimensionList != null) {
            this.dimensionList.func_231048_c_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        if (!this.popupOpen() && this.dimensionList != null) {
            return this.dimensionList.func_231045_a_(mouseX, mouseY, mouseEvent, deltaX, deltaY);
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (!this.popupOpen() && this.dimensionList != null) {
            return this.dimensionList.func_231043_a_(mouseX, mouseY, amount);
        }
        return true;
    }

    @Override
    public boolean overPopup(int x, int y) {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public boolean popupOpen() {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        float scScale = (float)this.getMinecraft().func_228018_at_().func_198100_s();
        this.tooltip = null;
        this.buttonEnabled.func_238482_a_((ITextComponent)new StringTextComponent(I18nUtils.getString("minimap.waypoints.enabled", new Object[0]) + " " + (this.waypoint.enabled ? I18nUtils.getString("options.on", new Object[0]) : I18nUtils.getString("options.off", new Object[0]))));
        if (!this.choosingColor && !this.choosingIcon) {
            this.func_230446_a_(matrixStack);
        }
        this.dimensionList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GuiAddWaypoint.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)(this.parentGui != null && this.parentGui.isEditing() || this.editing ? I18nUtils.getString("minimap.waypoints.edit", new Object[0]) : I18nUtils.getString("minimap.waypoints.new", new Object[0])), (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        GuiAddWaypoint.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("minimap.waypoints.name", new Object[0]), (int)(this.getWidth() / 2 - 100), (int)(this.getHeight() / 6 + 0), (int)0xA0A0A0);
        GuiAddWaypoint.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("X", new Object[0]), (int)(this.getWidth() / 2 - 100), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        GuiAddWaypoint.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("Z", new Object[0]), (int)(this.getWidth() / 2 - 28), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        GuiAddWaypoint.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("Y", new Object[0]), (int)(this.getWidth() / 2 + 44), (int)(this.getHeight() / 6 + 41), (int)0xA0A0A0);
        this.waypointName.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointX.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointZ.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.waypointY.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GLShim.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
        GLUtils.disp(-1);
        this.func_238474_b_(matrixStack, this.getWidth() / 2 - 25, buttonListY + 24 + 5, 0, 0, 16, 10);
        TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
        GLUtils.disp(chooser.func_110552_b());
        GLShim.glTexParameteri(3553, 10241, 9729);
        Sprite icon = chooser.getAtlasSprite("voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png");
        this.drawTexturedModalRect(this.getWidth() / 2 - 25, buttonListY + 48 + 2, icon, 16.0f, 16.0f);
        if (this.choosingColor || this.choosingIcon) {
            this.func_230446_a_(matrixStack);
        }
        if (this.choosingColor) {
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img(this.pickerResourceLocation);
            GLShim.glTexParameteri(3553, 10241, 9728);
            this.func_238474_b_(matrixStack, this.getWidth() / 2 - 128, this.getHeight() / 2 - 128, 0, 0, 256, 256);
        }
        if (this.choosingIcon) {
            float y;
            float x;
            float adj;
            float scale = scScale / 2.0f;
            float displayWidthFloat = (float)chooser.getWidth() / scale;
            float displayHeightFloat = (float)chooser.getHeight() / scale;
            if (displayWidthFloat > (float)this.getMinecraft().func_228018_at_().func_198109_k()) {
                adj = displayWidthFloat / (float)this.getMinecraft().func_228018_at_().func_198109_k();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            if (displayHeightFloat > (float)this.getMinecraft().func_228018_at_().func_198091_l()) {
                adj = displayHeightFloat / (float)this.getMinecraft().func_228018_at_().func_198091_l();
                displayWidthFloat /= adj;
                displayHeightFloat /= adj;
            }
            int displayWidth = (int)displayWidthFloat;
            int displayHeight = (int)displayHeightFloat;
            GLUtils.disp(-1);
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
            this.func_238474_b_(matrixStack, this.getWidth() / 2 - displayWidth / 2 - 1, this.getHeight() / 2 - displayHeight / 2 - 1, 0, 0, displayWidth + 2, displayHeight + 2);
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.func_238474_b_(matrixStack, this.getWidth() / 2 - displayWidth / 2, this.getHeight() / 2 - displayHeight / 2, 0, 0, displayWidth, displayHeight);
            GLShim.glColor4f(this.waypoint.red, this.waypoint.green, this.waypoint.blue, 1.0f);
            GLShim.glEnable(3042);
            GLUtils.disp(chooser.func_110552_b());
            GLShim.glTexParameteri(3553, 10241, 9729);
            GuiAddWaypoint.func_238466_a_((MatrixStack)matrixStack, (int)(this.getWidth() / 2 - displayWidth / 2), (int)(this.getHeight() / 2 - displayHeight / 2), (int)displayWidth, (int)displayHeight, (float)0.0f, (float)0.0f, (int)chooser.getWidth(), (int)chooser.getHeight(), (int)chooser.getImageWidth(), (int)chooser.getImageHeight());
            if (mouseX >= this.getWidth() / 2 - displayWidth / 2 && mouseX <= this.getWidth() / 2 + displayWidth / 2 && mouseY >= this.getHeight() / 2 - displayHeight / 2 && mouseY <= this.getHeight() / 2 + displayHeight / 2 && (icon = chooser.getIconAt(x = (float)(mouseX - (this.getWidth() / 2 - displayWidth / 2)) * scale, y = (float)(mouseY - (this.getHeight() / 2 - displayHeight / 2)) * scale)) != chooser.getMissingImage()) {
                this.tooltip = new StringTextComponent(icon.getIconName().replace("voxelmap:images/waypoints/waypoint", "").replace(".png", ""));
            }
            GLShim.glDisable(3042);
            GLShim.glTexParameteri(3553, 10241, 9728);
        }
        if (this.tooltip != null) {
            this.func_238652_a_(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public void setSelectedDimension(DimensionContainer dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension) && this.selectedDimension != this.master.getDimensionManager().getDimensionContainerByWorld((World)Minecraft.func_71410_x().field_71441_e)) {
            this.waypoint.dimensions.remove(this.selectedDimension);
        } else if (!this.waypoint.dimensions.contains(this.selectedDimension)) {
            this.waypoint.dimensions.add(this.selectedDimension);
        }
    }

    static ITextComponent setTooltip(GuiAddWaypoint par0GuiWaypoint, ITextComponent par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
        return par0GuiWaypoint.tooltip;
    }

    public void drawTexturedModalRect(Sprite icon, float x, float y) {
        float width = (float)icon.getIconWidth() / 2.0f;
        float height = (float)icon.getIconHeight() / 2.0f;
        this.drawTexturedModalRect(x, y, icon, width, height);
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_((double)(xCoord + 0.0f), (double)(yCoord + heightIn), (double)this.func_230927_p_()).func_225583_a_(icon.getMinU(), icon.getMaxV()).func_181675_d();
        vertexbuffer.func_225582_a_((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)this.func_230927_p_()).func_225583_a_(icon.getMaxU(), icon.getMaxV()).func_181675_d();
        vertexbuffer.func_225582_a_((double)(xCoord + widthIn), (double)(yCoord + 0.0f), (double)this.func_230927_p_()).func_225583_a_(icon.getMaxU(), icon.getMinV()).func_181675_d();
        vertexbuffer.func_225582_a_((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.func_230927_p_()).func_225583_a_(icon.getMinU(), icon.getMinV()).func_181675_d();
        tessellator.func_78381_a();
    }
}

