/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiButtonText;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMinimapPerformance
extends GuiScreenMinimap {
    private static final EnumOptionsMinimap[] relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.LIGHTING, EnumOptionsMinimap.TERRAIN, EnumOptionsMinimap.WATERTRANSPARENCY, EnumOptionsMinimap.BLOCKTRANSPARENCY, EnumOptionsMinimap.BIOMES, EnumOptionsMinimap.FILTERING, EnumOptionsMinimap.CHUNKGRID, EnumOptionsMinimap.BIOMEOVERLAY, EnumOptionsMinimap.SLIMECHUNKS};
    private GuiButtonText worldSeedButton;
    private GuiOptionButtonMinimap slimeChunksButton;
    private Screen parentScreen;
    protected String screenTitle = "Details / Performance";
    private MapSettingsManager options;
    IVoxelMap master;

    public GuiMinimapPerformance(Screen par1GuiScreen, IVoxelMap master) {
        this.parentScreen = par1GuiScreen;
        this.options = master.getMapOptions();
        this.master = master;
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void func_231160_c_() {
        this.screenTitle = I18nUtils.getString("options.minimap.detailsperformance", new Object[0]);
        this.getMinecraft().field_195559_v.func_197967_a(true);
        int leftBorder = this.getLeftBorder();
        int var2 = 0;
        for (int t = 0; t < relevantOptions.length; ++t) {
            EnumOptionsMinimap option = relevantOptions[t];
            String text = this.options.getKeyText(option);
            if ((option == EnumOptionsMinimap.WATERTRANSPARENCY || option == EnumOptionsMinimap.BLOCKTRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
                text = "\u00a7c" + text;
            }
            GuiOptionButtonMinimap optionButton = new GuiOptionButtonMinimap(leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (ITextComponent)new StringTextComponent(text), button -> this.optionClicked(button));
            this.func_230480_a_((Widget)optionButton);
            ++var2;
            if (!optionButton.returnEnumOptions().equals((Object)EnumOptionsMinimap.SLIMECHUNKS)) continue;
            this.slimeChunksButton = optionButton;
            this.slimeChunksButton.field_230693_o_ = this.getMinecraft().func_71387_A() || !this.master.getWorldSeed().equals("");
        }
        String worldSeedDisplay = this.master.getWorldSeed();
        if (worldSeedDisplay.equals("")) {
            worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
        }
        String buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton = new GuiButtonText(this.getFontRenderer(), leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), 150, 20, (ITextComponent)new StringTextComponent(buttonText), button -> this.worldSeedButton.setEditing(true));
        this.worldSeedButton.setText(this.master.getWorldSeed());
        this.worldSeedButton.field_230693_o_ = !this.getMinecraft().func_71387_A();
        this.func_230480_a_((Widget)this.worldSeedButton);
        ++var2;
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parentScreen)));
    }

    @Override
    public void func_231164_f_() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    protected void optionClicked(Button par1GuiButton) {
        EnumOptionsMinimap option = ((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions();
        this.options.setOptionValue(option);
        String perfBomb = "";
        if ((option == EnumOptionsMinimap.WATERTRANSPARENCY || option == EnumOptionsMinimap.BLOCKTRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
            perfBomb = "\u00a7c";
        }
        par1GuiButton.func_238482_a_((ITextComponent)new StringTextComponent(perfBomb + this.options.getKeyText(option)));
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        if (keysm == 258) {
            this.worldSeedButton.func_231046_a_(keysm, scancode, b);
        }
        if ((keysm == 257 || keysm == 335) && this.worldSeedButton.isEditing()) {
            this.newSeed();
        }
        return super.func_231046_a_(keysm, scancode, b);
    }

    public boolean func_231042_a_(char character, int keycode) {
        boolean OK = super.func_231042_a_(character, keycode);
        if (character == '\r' && this.worldSeedButton.isEditing()) {
            this.newSeed();
        }
        return OK;
    }

    private void newSeed() {
        String newSeed = this.worldSeedButton.getText();
        this.master.setWorldSeed(newSeed);
        String worldSeedDisplay = this.master.getWorldSeed();
        if (worldSeedDisplay.equals("")) {
            worldSeedDisplay = I18nUtils.getString("selectWorld.versionUnknown", new Object[0]);
        }
        String buttonText = I18nUtils.getString("options.minimap.worldseed", new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton.func_238482_a_((ITextComponent)new StringTextComponent(buttonText));
        this.worldSeedButton.setText(this.master.getWorldSeed());
        this.master.getMap().forceFullRender(true);
        this.slimeChunksButton.field_230693_o_ = this.getMinecraft().func_71387_A() || !this.master.getWorldSeed().equals("");
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.func_230446_a_(matrixStack);
        GuiMinimapPerformance.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        this.worldSeedButton.tick();
    }
}

