/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiSlotMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMobs
extends GuiScreenMinimap {
    private final Screen parentScreen;
    protected final RadarSettingsManager options;
    protected ITextComponent screenTitle;
    private GuiSlotMobs mobsList;
    private Button buttonEnable;
    private Button buttonDisable;
    protected TextFieldWidget filter;
    private ITextComponent tooltip = null;
    protected String selectedMobId = null;

    public GuiMobs(Screen parentScreen, RadarSettingsManager options) {
        this.parentScreen = parentScreen;
        this.options = options;
    }

    public void func_231023_e_() {
        this.filter.func_146178_a();
    }

    public void func_231160_c_() {
        boolean isSomethingSelected;
        this.screenTitle = new TranslationTextComponent("options.minimap.mobs.title");
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.mobsList = new GuiSlotMobs(this);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 56, 305 - filterStringWidth - 5, 20, null);
        this.filter.func_146203_f(35);
        this.func_230480_a_((Widget)this.filter);
        this.buttonEnable = new Button(this.getWidth() / 2 - 154, this.getHeight() - 28, 100, 20, (ITextComponent)new TranslationTextComponent("options.minimap.mobs.enable"), button -> this.setMobEnabled(this.selectedMobId, true));
        this.func_230480_a_((Widget)this.buttonEnable);
        this.buttonDisable = new Button(this.getWidth() / 2 - 50, this.getHeight() - 28, 100, 20, (ITextComponent)new TranslationTextComponent("options.minimap.mobs.disable"), button -> this.setMobEnabled(this.selectedMobId, false));
        this.func_230480_a_((Widget)this.buttonDisable);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 4 + 50, this.getHeight() - 28, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parentScreen)));
        this.func_231035_a_((IGuiEventListener)this.filter);
        this.filter.func_146195_b(true);
        this.buttonEnable.field_230693_o_ = isSomethingSelected = this.selectedMobId != null;
        this.buttonDisable.field_230693_o_ = isSomethingSelected;
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        boolean OK = super.func_231046_a_(keysm, scancode, b);
        if (this.filter.func_230999_j_()) {
            this.mobsList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean func_231042_a_(char character, int keycode) {
        boolean OK = super.func_231042_a_(character, keycode);
        if (this.filter.func_230999_j_()) {
            this.mobsList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.mobsList.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.mobsList.func_231048_c_(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.mobsList.func_231045_a_(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.mobsList.func_231043_a_(mouseX, mouseY, amount);
    }

    protected void setSelectedMob(String id) {
        this.selectedMobId = id;
    }

    private boolean isMobEnabled(String mobId) {
        EnumMobs mob = EnumMobs.getMobByName(mobId);
        if (mob != null) {
            return mob.enabled;
        }
        CustomMob customMob = CustomMobsManager.getCustomMobByType(mobId);
        if (customMob != null) {
            return customMob.enabled;
        }
        return false;
    }

    private void setMobEnabled(String mobId, boolean enabled) {
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.id.equals(mobId)) continue;
            mob.enabled = enabled;
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if (!mob.id.equals(mobId)) continue;
            mob.enabled = enabled;
        }
    }

    protected void toggleMobVisibility() {
        EnumMobs mob = EnumMobs.getMobByName(this.selectedMobId);
        if (mob != null) {
            this.setMobEnabled(this.selectedMobId, !mob.enabled);
        } else {
            CustomMob customMob = CustomMobsManager.getCustomMobByType(this.selectedMobId);
            if (customMob != null) {
                this.setMobEnabled(this.selectedMobId, !customMob.enabled);
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialticks) {
        super.drawMap(matrixStack);
        this.tooltip = null;
        this.mobsList.func_230430_a_(matrixStack, mouseX, mouseY, partialticks);
        GuiMobs.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (ITextComponent)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        boolean isSomethingSelected = this.selectedMobId != null;
        this.buttonEnable.field_230693_o_ = isSomethingSelected && !this.isMobEnabled(this.selectedMobId);
        this.buttonDisable.field_230693_o_ = isSomethingSelected && this.isMobEnabled(this.selectedMobId);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialticks);
        GuiMobs.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":"), (int)(this.getWidth() / 2 - 153), (int)(this.getHeight() - 51), (int)0xA0A0A0);
        this.filter.func_230430_a_(matrixStack, mouseX, mouseY, partialticks);
        if (this.tooltip != null) {
            this.func_238652_a_(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    static ITextComponent setTooltip(GuiMobs par0GuiWaypoints, ITextComponent par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231164_f_();
    }
}

