/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

class GuiSlotMobs
extends GuiSlotMinimap<MobItem> {
    private ArrayList<MobItem> mobs;
    private ArrayList<MobItem> mobsFiltered;
    private RadarSettingsManager options;
    final GuiMobs parentGui;
    final TranslationTextComponent ENABLE = new TranslationTextComponent("options.minimap.mobs.enable");
    final TranslationTextComponent DISABLE = new TranslationTextComponent("options.minimap.mobs.disable");
    final TranslationTextComponent ENABLED = new TranslationTextComponent("options.minimap.mobs.enabled");
    final TranslationTextComponent DISABLED = new TranslationTextComponent("options.minimap.mobs.disabled");

    public GuiSlotMobs(GuiMobs par1GuiMobs) {
        super(par1GuiMobs.options.game, par1GuiMobs.getWidth(), par1GuiMobs.getHeight(), 32, par1GuiMobs.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiMobs;
        this.options = this.parentGui.options;
        this.mobs = new ArrayList();
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.isTopLevelUnit || (!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if ((!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.mobs, new Comparator<MobItem>(){

            @Override
            public int compare(MobItem mob1, MobItem mob2) {
                return collator.compare(mob1.name, mob2.name);
            }
        });
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        this.mobsFiltered.forEach(arg_0 -> ((GuiSlotMobs)this).func_230513_b_(arg_0));
    }

    private static String getTranslatedName(String name) {
        if (name.indexOf(".") == -1) {
            name = "entity.minecraft." + name.toLowerCase();
        }
        name = I18nUtils.getString(name, new Object[0]);
        name = name.replaceAll("^entity.minecraft.", "");
        name = name.replace("_", " ");
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        name = TextUtils.scrubCodes(name);
        return name;
    }

    public void setSelected(MobItem item) {
        super.func_241215_a_((AbstractList.AbstractListEntry)item);
        if (this.func_230958_g_() instanceof MobItem) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new Object[]{((MobItem)this.func_230958_g_()).name}).getString());
        }
        this.parentGui.setSelectedMob(item.id);
    }

    protected boolean func_230957_f_(int par1) {
        return this.mobsFiltered.get(par1).id.equals(this.parentGui.selectedMobId);
    }

    protected int func_230945_b_() {
        return this.func_230965_k_() * this.field_230669_c_;
    }

    public void func_230433_a_(MatrixStack matrixStack) {
        this.parentGui.func_230446_a_(matrixStack);
    }

    protected void updateFilter(String filterString) {
        this.func_230963_j_();
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        Iterator<MobItem> iterator = this.mobsFiltered.iterator();
        while (iterator.hasNext()) {
            String mobName = iterator.next().name;
            if (mobName.toLowerCase().contains(filterString)) continue;
            if (mobName == this.parentGui.selectedMobId) {
                this.parentGui.setSelectedMob(null);
            }
            iterator.remove();
        }
        this.mobsFiltered.forEach(arg_0 -> ((GuiSlotMobs)this).func_230513_b_(arg_0));
    }

    public class MobItem
    extends AbstractList.AbstractListEntry<MobItem> {
        private final GuiMobs parentGui;
        private final String id;
        private final String name;

        protected MobItem(GuiMobs mobsScreen, String id) {
            this.parentGui = mobsScreen;
            this.id = id;
            this.name = GuiSlotMobs.getTranslatedName(id);
        }

        public void func_230432_a_(MatrixStack matrixStack, int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            boolean isHostile = false;
            boolean isNeutral = false;
            boolean isEnabled = true;
            EnumMobs mob = EnumMobs.getMobByName(this.id);
            if (mob != null) {
                isHostile = mob.isHostile;
                isNeutral = mob.isNeutral;
                isEnabled = mob.enabled;
            } else {
                CustomMob customMob = CustomMobsManager.getCustomMobByType(this.id);
                if (customMob != null) {
                    isHostile = customMob.isHostile;
                    isNeutral = customMob.isNeutral;
                    isEnabled = customMob.enabled;
                }
            }
            int red = isHostile ? 255 : 0;
            int green = isNeutral ? 255 : 0;
            int color = -16777216 + (red << 16) + (green << 8) + 0;
            GuiMobs.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.parentGui.getFontRenderer(), (String)this.name, (int)(this.parentGui.getWidth() / 2), (int)(slotYPos + 3), (int)color);
            int padding = 3;
            if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + GuiSlotMobs.this.field_230669_c_) {
                TranslationTextComponent tooltip = mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding ? (isEnabled ? GuiSlotMobs.this.DISABLE : GuiSlotMobs.this.ENABLE) : (isEnabled ? GuiSlotMobs.this.ENABLED : GuiSlotMobs.this.DISABLED);
                GuiMobs.setTooltip(this.parentGui, (ITextComponent)tooltip);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img("textures/mob_effect/" + (isEnabled ? "night_vision.png" : "blindness.png"));
            AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)(leftEdge + 198), (int)(slotYPos - 2), (int)GuiSlotMobs.this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseEvent) {
            GuiSlotMobs.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleMobVisibility();
            } else if (GuiSlotMobs.this.doubleclick) {
                this.parentGui.toggleMobVisibility();
            }
            return true;
        }
    }
}

