/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSubworldEdit
extends GuiScreenMinimap
implements BooleanConsumer {
    private Screen parent;
    private IWaypointManager waypointManager;
    private ArrayList<String> knownSubworldNames;
    private String originalSubworldName = "";
    private String currentSubworldName = "";
    private TextFieldWidget subworldNameField;
    private Button doneButton;
    private Button deleteButton;
    private boolean deleteClicked = false;

    public GuiSubworldEdit(Screen parent, IVoxelMap master, String subworldName) {
        this.parent = parent;
        this.waypointManager = master.getWaypointManager();
        this.originalSubworldName = subworldName;
        this.knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
    }

    public void func_231023_e_() {
        this.subworldNameField.func_146178_a();
    }

    public void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.getButtonList().clear();
        this.subworldNameField = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20, null);
        this.func_231035_a_((IGuiEventListener)this.subworldNameField);
        this.subworldNameField.func_146195_b(true);
        this.subworldNameField.func_146180_a(this.originalSubworldName);
        this.func_230480_a_((Widget)this.subworldNameField);
        this.doneButton = new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.changeNameClicked());
        this.func_230480_a_((Widget)this.doneButton);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.getMinecraft().func_147108_a(this.parent)));
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.deleteButton = new Button(this.getWidth() / 2 - 50, buttonListY + 24, 100, 20, (ITextComponent)new TranslationTextComponent("selectServer.delete"), button -> this.deleteClicked());
        this.func_230480_a_((Widget)this.deleteButton);
        this.doneButton.field_230693_o_ = this.isNameAcceptable();
        this.deleteButton.field_230693_o_ = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
    }

    @Override
    public void func_231164_f_() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    private void changeNameClicked() {
        if (!this.currentSubworldName.equals(this.originalSubworldName)) {
            this.waypointManager.changeSubworldName(this.originalSubworldName, this.currentSubworldName);
        }
        this.getMinecraft().func_147108_a(this.parent);
    }

    private void deleteClicked() {
        this.deleteClicked = true;
        TranslationTextComponent title = new TranslationTextComponent("worldmap.subworld.deleteconfirm");
        TranslationTextComponent explanation = new TranslationTextComponent("selectServer.deleteWarning", new Object[]{this.originalSubworldName});
        TranslationTextComponent affirm = new TranslationTextComponent("selectServer.deleteButton");
        TranslationTextComponent deny = new TranslationTextComponent("gui.cancel");
        ConfirmScreen confirmScreen = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)title, (ITextComponent)explanation, (ITextComponent)affirm, (ITextComponent)deny);
        this.getMinecraft().func_147108_a((Screen)confirmScreen);
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteSubworld(this.originalSubworldName);
            }
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        boolean OK = super.func_231046_a_(keysm, scancode, b);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.field_230693_o_ = this.isNameAcceptable();
        this.deleteButton.field_230693_o_ = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
        if ((keysm == 257 || keysm == 335) && acceptable) {
            this.changeNameClicked();
        }
        return OK;
    }

    public boolean func_231042_a_(char character, int keycode) {
        boolean OK = super.func_231042_a_(character, keycode);
        boolean acceptable = this.isNameAcceptable();
        this.doneButton.field_230693_o_ = this.isNameAcceptable();
        this.deleteButton.field_230693_o_ = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
        if (character == '\r' && acceptable) {
            this.changeNameClicked();
        }
        return OK;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int par3) {
        this.subworldNameField.func_231044_a_(mouseX, mouseY, par3);
        return super.func_231044_a_(mouseX, mouseY, par3);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.func_230446_a_(matrixStack);
        GuiSubworldEdit.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("worldmap.subworld.edit", new Object[0]), (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        GuiSubworldEdit.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)I18nUtils.getString("worldmap.subworld.name", new Object[0]), (int)(this.getWidth() / 2 - 100), (int)(this.getHeight() / 6 + 0), (int)0xA0A0A0);
        this.subworldNameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private boolean isNameAcceptable() {
        boolean acceptable = true;
        this.currentSubworldName = this.subworldNameField.func_146179_b();
        acceptable = acceptable && this.currentSubworldName.length() > 0;
        acceptable = acceptable && (this.currentSubworldName.equals(this.originalSubworldName) || !this.knownSubworldNames.contains(this.currentSubworldName));
        return acceptable;
    }
}

