/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

public class NetworkUtils {
    private static ArrayList<InterfaceAddress> interfaceAddresses;

    public static void enumerateInterfaces() throws SocketException {
        interfaceAddresses = new ArrayList();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            try {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<NetworkInterface> subInterfaces = networkInterface.getSubInterfaces();
                while (subInterfaces.hasMoreElements()) {
                    try {
                        NetworkInterface subNetworkInterface = subInterfaces.nextElement();
                        for (InterfaceAddress interfaceAddress : subNetworkInterface.getInterfaceAddresses()) {
                            if (interfaceAddress == null) continue;
                            interfaceAddresses.add(interfaceAddress);
                        }
                    }
                    catch (Exception subNetworkInterface) {
                    }
                }
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (interfaceAddress == null) continue;
                    interfaceAddresses.add(interfaceAddress);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public static boolean isOnLan(InetAddress serverAddress) {
        for (int t = 0; t < interfaceAddresses.size(); ++t) {
            try {
                InterfaceAddress interfaceAddress = interfaceAddresses.get(t);
                if (!NetworkUtils.onSameNetwork(serverAddress, interfaceAddress.getAddress(), (int)interfaceAddress.getNetworkPrefixLength())) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean onSameNetwork(InetAddress a, InetAddress b, int mask) {
        return NetworkUtils.onSameNetwork(a.getAddress(), b.getAddress(), mask);
    }

    private static boolean onSameNetwork(byte[] x, byte[] y, int mask) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        int bits = mask & 7;
        int bytes = mask >>> 3;
        for (int i = 0; i < bytes; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        int shift = 8 - bits;
        return bits == 0 || x[bytes] >>> shift == y[bytes] >>> shift;
    }
}

