/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.block.FragileGlassBlock;
import com.fredtargaryen.fragileglass.block.FragilePaneBlock;
import com.fredtargaryen.fragileglass.block.StainedFragileGlassBlock;
import com.fredtargaryen.fragileglass.block.StainedFragilePaneBlock;
import com.fredtargaryen.fragileglass.block.SugarBlock;
import com.fredtargaryen.fragileglass.block.SugarCauldronBlock;
import com.fredtargaryen.fragileglass.block.ThinIceBlock;
import com.fredtargaryen.fragileglass.block.WeakStoneBlock;
import com.fredtargaryen.fragileglass.client.particle.MyBubbleParticle;
import com.fredtargaryen.fragileglass.command.CommandsBase;
import com.fredtargaryen.fragileglass.config.Config;
import com.fredtargaryen.fragileglass.config.WorldgenConfig;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.BlockDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.EntityDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.TileEntityDataManager;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapFactory;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapStorage;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.IPlayerBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakFactory;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakStorage;
import com.fredtargaryen.fragileglass.network.MessageBreakerMovement;
import com.fredtargaryen.fragileglass.network.PacketHandler;
import com.fredtargaryen.fragileglass.proxy.ClientProxy;
import com.fredtargaryen.fragileglass.proxy.IProxy;
import com.fredtargaryen.fragileglass.proxy.ServerProxy;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapFactory;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapStorage;
import com.fredtargaryen.fragileglass.tileentity.capability.IFragileCapability;
import com.fredtargaryen.fragileglass.world.BreakSystem;
import com.fredtargaryen.fragileglass.worldgen.FeatureManager;
import com.fredtargaryen.fragileglass.worldgen.IcePatchGenConfig;
import com.fredtargaryen.fragileglass.worldgen.StonePatchGenConfig;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fragileglassft")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="fragileglassft")
public class FragileGlassBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Tag<Block> ICE_BLOCKS;
    private static BlockDataManager blockDataManager;
    private static EntityDataManager entityDataManager;
    private static TileEntityDataManager tileEntityDataManager;
    @ObjectHolder(value="fragileglass")
    public static Block FRAGILE_GLASS;
    @ObjectHolder(value="fragilepane")
    public static Block FRAGILE_PANE;
    @ObjectHolder(value="whitestainedfragileglass")
    public static Block WHITE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="orangestainedfragileglass")
    public static Block ORANGE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="magentastainedfragileglass")
    public static Block MAGENTA_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="lightbluestainedfragileglass")
    public static Block LIGHT_BLUE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="yellowstainedfragileglass")
    public static Block YELLOW_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="limestainedfragileglass")
    public static Block LIME_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="pinkstainedfragileglass")
    public static Block PINK_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="graystainedfragileglass")
    public static Block GRAY_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="lightgraystainedfragileglass")
    public static Block LIGHT_GRAY_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="cyanstainedfragileglass")
    public static Block CYAN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="purplestainedfragileglass")
    public static Block PURPLE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="bluestainedfragileglass")
    public static Block BLUE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="brownstainedfragileglass")
    public static Block BROWN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="greenstainedfragileglass")
    public static Block GREEN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="redstainedfragileglass")
    public static Block RED_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="blackstainedfragileglass")
    public static Block BLACK_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="whitestainedfragileglasspane")
    public static Block WHITE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="orangestainedfragileglasspane")
    public static Block ORANGE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="magentastainedfragileglasspane")
    public static Block MAGENTA_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="lightbluestainedfragileglasspane")
    public static Block LIGHT_BLUE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="yellowstainedfragileglasspane")
    public static Block YELLOW_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="limestainedfragileglasspane")
    public static Block LIME_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="pinkstainedfragileglasspane")
    public static Block PINK_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="graystainedfragileglasspane")
    public static Block GRAY_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="lightgraystainedfragileglasspane")
    public static Block LIGHT_GRAY_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="cyanstainedfragileglasspane")
    public static Block CYAN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="purplestainedfragileglasspane")
    public static Block PURPLE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="bluestainedfragileglasspane")
    public static Block BLUE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="brownstainedfragileglasspane")
    public static Block BROWN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="greenstainedfragileglasspane")
    public static Block GREEN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="redstainedfragileglasspane")
    public static Block RED_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="blackstainedfragileglasspane")
    public static Block BLACK_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="sugarblock")
    public static Block SUGAR_BLOCK;
    @ObjectHolder(value="thinice")
    public static Block THIN_ICE;
    @ObjectHolder(value="sugarcauldron")
    public static Block SUGAR_CAULDRON;
    @ObjectHolder(value="weakstone")
    public static Block WEAK_STONE;
    @ObjectHolder(value="fragileglass")
    public static Item ITEM_FRAGILE_GLASS;
    @ObjectHolder(value="fragilepane")
    public static Item ITEM_FRAGILE_PANE;
    @ObjectHolder(value="whitestainedfragileglass")
    public static Item ITEM_WHITE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="orangestainedfragileglass")
    public static Item ITEM_ORANGE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="magentastainedfragileglass")
    public static Item ITEM_MAGENTA_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="lightbluestainedfragileglass")
    public static Item ITEM_LIGHT_BLUE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="yellowstainedfragileglass")
    public static Item ITEM_YELLOW_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="limestainedfragileglass")
    public static Item ITEM_LIME_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="pinkstainedfragileglass")
    public static Item ITEM_PINK_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="graystainedfragileglass")
    public static Item ITEM_GRAY_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="lightgraystainedfragileglass")
    public static Item ITEM_LIGHT_GRAY_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="cyanstainedfragileglass")
    public static Item ITEM_CYAN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="purplestainedfragileglass")
    public static Item ITEM_PURPLE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="bluestainedfragileglass")
    public static Item ITEM_BLUE_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="brownstainedfragileglass")
    public static Item ITEM_BROWN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="greenstainedfragileglass")
    public static Item ITEM_GREEN_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="redstainedfragileglass")
    public static Item ITEM_RED_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="blackstainedfragileglass")
    public static Item ITEM_BLACK_STAINED_FRAGILE_GLASS;
    @ObjectHolder(value="whitestainedfragileglasspane")
    public static Item ITEM_WHITE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="orangestainedfragileglasspane")
    public static Item ITEM_ORANGE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="magentastainedfragileglasspane")
    public static Item ITEM_MAGENTA_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="lightbluestainedfragileglasspane")
    public static Item ITEM_LIGHT_BLUE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="yellowstainedfragileglasspane")
    public static Item ITEM_YELLOW_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="limestainedfragileglasspane")
    public static Item ITEM_LIME_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="pinkstainedfragileglasspane")
    public static Item ITEM_PINK_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="graystainedfragileglasspane")
    public static Item ITEM_GRAY_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="lightgraystainedfragileglasspane")
    public static Item ITEM_LIGHT_GRAY_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="cyanstainedfragileglasspane")
    public static Item ITEM_CYAN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="purplestainedfragileglasspane")
    public static Item ITEM_PURPLE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="bluestainedfragileglasspane")
    public static Item ITEM_BLUE_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="brownstainedfragileglasspane")
    public static Item ITEM_BROWN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="greenstainedfragileglasspane")
    public static Item ITEM_GREEN_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="redstainedfragileglasspane")
    public static Item ITEM_RED_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="blackstainedfragileglasspane")
    public static Item ITEM_BLACK_STAINED_FRAGILE_GLASS_PANE;
    @ObjectHolder(value="sugarblock")
    public static Item ITEM_SUGAR_BLOCK;
    @ObjectHolder(value="thinice")
    public static Item ITEM_THIN_ICE;
    @ObjectHolder(value="sugarcauldron")
    public static Item ITEM_SUGAR_CAULDRON;
    @ObjectHolder(value="weakstone")
    public static Item ITEM_WEAK_STONE;
    @ObjectHolder(value="icepatchgen")
    public static Feature<IcePatchGenConfig> ICE_FEATURE;
    @ObjectHolder(value="stonepatchgen")
    public static Feature<StonePatchGenConfig> STONE_FEATURE;
    @ObjectHolder(value="bubble")
    public static BasicParticleType BUBBLE;
    public static FeatureManager FEATURE_MANAGER;
    private static IProxy proxy;
    @CapabilityInject(value=IBreakCapability.class)
    public static Capability<IBreakCapability> BREAKCAP;
    @CapabilityInject(value=IPlayerBreakCapability.class)
    public static Capability<IPlayerBreakCapability> PLAYERBREAKCAP;
    @CapabilityInject(value=IFragileCapability.class)
    public static Capability<IFragileCapability> FRAGILECAP;
    private static final ITextComponent SUCCESS_MESSAGE;
    private static final ITextComponent FAILURE_MESSAGE;
    private static ITextComponent STATUS;
    private static CommandSource cachedCommandSource;

    public FragileGlassBase() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG_SPEC);
        IEventBus loadingBus = FMLJavaModLoadingContext.get().getModEventBus();
        loadingBus.addListener(this::postRegistration);
        loadingBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(FMLPaths.CONFIGDIR.get().resolve("fragileglassft-common.toml"));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new FragileGlassBlock().setRegistryName("fragileglass"), (Block)new FragilePaneBlock().setRegistryName("fragilepane"), (Block)new SugarBlock().setRegistryName("sugarblock"), (Block)new ThinIceBlock().setRegistryName("thinice"), (Block)new SugarCauldronBlock().setRegistryName("sugarcauldron"), (Block)new WeakStoneBlock().setRegistryName("weakstone"), (Block)new StainedFragileGlassBlock(DyeColor.WHITE).setRegistryName("whitestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.ORANGE).setRegistryName("orangestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.MAGENTA).setRegistryName("magentastainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.LIGHT_BLUE).setRegistryName("lightbluestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.YELLOW).setRegistryName("yellowstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.LIME).setRegistryName("limestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.PINK).setRegistryName("pinkstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.GRAY).setRegistryName("graystainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.LIGHT_GRAY).setRegistryName("lightgraystainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.CYAN).setRegistryName("cyanstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.PURPLE).setRegistryName("purplestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.BLUE).setRegistryName("bluestainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.BROWN).setRegistryName("brownstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.GREEN).setRegistryName("greenstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.RED).setRegistryName("redstainedfragileglass"), (Block)new StainedFragileGlassBlock(DyeColor.BLACK).setRegistryName("blackstainedfragileglass"), (Block)new StainedFragilePaneBlock(DyeColor.WHITE).setRegistryName("whitestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.ORANGE).setRegistryName("orangestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.MAGENTA).setRegistryName("magentastainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.LIGHT_BLUE).setRegistryName("lightbluestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.YELLOW).setRegistryName("yellowstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.LIME).setRegistryName("limestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.PINK).setRegistryName("pinkstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.GRAY).setRegistryName("graystainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.LIGHT_GRAY).setRegistryName("lightgraystainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.CYAN).setRegistryName("cyanstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.PURPLE).setRegistryName("purplestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.BLUE).setRegistryName("bluestainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.BROWN).setRegistryName("brownstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.GREEN).setRegistryName("greenstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.RED).setRegistryName("redstainedfragileglasspane"), (Block)new StainedFragilePaneBlock(DyeColor.BLACK).setRegistryName("blackstainedfragileglasspane")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("fragileglass"), (Item)new BlockItem(FRAGILE_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("fragilepane"), (Item)new BlockItem(SUGAR_BLOCK, new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName("sugarblock"), (Item)new BlockItem(THIN_ICE, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("thinice"), (Item)new BlockItem(SUGAR_CAULDRON, new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName("sugarcauldron"), (Item)new BlockItem(WEAK_STONE, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("weakstone"), (Item)new BlockItem(WHITE_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("whitestainedfragileglass"), (Item)new BlockItem(ORANGE_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("orangestainedfragileglass"), (Item)new BlockItem(MAGENTA_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("magentastainedfragileglass"), (Item)new BlockItem(LIGHT_BLUE_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("lightbluestainedfragileglass"), (Item)new BlockItem(YELLOW_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("yellowstainedfragileglass"), (Item)new BlockItem(LIME_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("limestainedfragileglass"), (Item)new BlockItem(PINK_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("pinkstainedfragileglass"), (Item)new BlockItem(GRAY_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("graystainedfragileglass"), (Item)new BlockItem(LIGHT_GRAY_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("lightgraystainedfragileglass"), (Item)new BlockItem(CYAN_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("cyanstainedfragileglass"), (Item)new BlockItem(PURPLE_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("purplestainedfragileglass"), (Item)new BlockItem(BLUE_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("bluestainedfragileglass"), (Item)new BlockItem(BROWN_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("brownstainedfragileglass"), (Item)new BlockItem(GREEN_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("greenstainedfragileglass"), (Item)new BlockItem(RED_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("redstainedfragileglass"), (Item)new BlockItem(BLACK_STAINED_FRAGILE_GLASS, new Item.Properties().func_200916_a(ItemGroup.field_78030_b)).setRegistryName("blackstainedfragileglass"), (Item)new BlockItem(WHITE_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("whitestainedfragileglasspane"), (Item)new BlockItem(ORANGE_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("orangestainedfragileglasspane"), (Item)new BlockItem(MAGENTA_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("magentastainedfragileglasspane"), (Item)new BlockItem(LIGHT_BLUE_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("lightbluestainedfragileglasspane"), (Item)new BlockItem(YELLOW_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("yellowstainedfragileglasspane"), (Item)new BlockItem(LIME_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("limestainedfragileglasspane"), (Item)new BlockItem(PINK_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("pinkstainedfragileglasspane"), (Item)new BlockItem(GRAY_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("graystainedfragileglasspane"), (Item)new BlockItem(LIGHT_GRAY_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("lightgraystainedfragileglasspane"), (Item)new BlockItem(CYAN_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("cyanstainedfragileglasspane"), (Item)new BlockItem(PURPLE_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("purplestainedfragileglasspane"), (Item)new BlockItem(BLUE_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("bluestainedfragileglasspane"), (Item)new BlockItem(BROWN_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("brownstainedfragileglasspane"), (Item)new BlockItem(GREEN_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("greenstainedfragileglasspane"), (Item)new BlockItem(RED_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("redstainedfragileglasspane"), (Item)new BlockItem(BLACK_STAINED_FRAGILE_GLASS_PANE, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName("blackstainedfragileglasspane")});
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        FEATURE_MANAGER = new FeatureManager();
        FEATURE_MANAGER.registerFeatures(event);
    }

    @SubscribeEvent
    public static void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        event.getRegistry().register(new BasicParticleType(false).setRegistryName("bubble"));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)BUBBLE, MyBubbleParticle.Factory::new);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        proxy.setupRenderTypes();
    }

    public void postRegistration(FMLCommonSetupEvent event) {
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(IBreakCapability.class, (Capability.IStorage)new BreakCapStorage(), (Callable)new BreakCapFactory());
        CapabilityManager.INSTANCE.register(IPlayerBreakCapability.class, (Capability.IStorage)new PlayerBreakStorage(), (Callable)new PlayerBreakFactory());
        CapabilityManager.INSTANCE.register(IFragileCapability.class, (Capability.IStorage)new FragileCapStorage(), (Callable)new FragileCapFactory());
        blockDataManager = new BlockDataManager();
        entityDataManager = new EntityDataManager();
        tileEntityDataManager = new TileEntityDataManager();
        FEATURE_MANAGER.registerGenerators();
    }

    @SubscribeEvent
    public void handleMissingMappings(RegistryEvent.MissingMappings evt) {
        block43: {
            String fullName;
            block42: {
                fullName = evt.getName().toString();
                if (!fullName.equals("minecraft:blocks")) break block42;
                for (Object mapping : evt.getAllMappings()) {
                    RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                    if (!trueMapping.key.func_110624_b().equals("ftfragileglass")) continue;
                    switch (trueMapping.key.func_110623_a()) {
                        case "ftfragileglass": {
                            trueMapping.remap((IForgeRegistryEntry)FRAGILE_GLASS);
                            break;
                        }
                        case "ftfragilepane": {
                            trueMapping.remap((IForgeRegistryEntry)FRAGILE_PANE);
                            break;
                        }
                        case "ftstainedfragileglass": {
                            trueMapping.remap((IForgeRegistryEntry)WHITE_STAINED_FRAGILE_GLASS);
                            break;
                        }
                        case "ftstainedfragilepane": {
                            trueMapping.remap((IForgeRegistryEntry)WHITE_STAINED_FRAGILE_GLASS_PANE);
                            break;
                        }
                        case "ftthinice": {
                            trueMapping.remap((IForgeRegistryEntry)THIN_ICE);
                            break;
                        }
                        case "ftweakstone": {
                            trueMapping.remap((IForgeRegistryEntry)WEAK_STONE);
                            break;
                        }
                        case "ftsugarcauldron": {
                            trueMapping.remap((IForgeRegistryEntry)SUGAR_CAULDRON);
                            break;
                        }
                        case "ftsugarblock": {
                            trueMapping.remap((IForgeRegistryEntry)SUGAR_BLOCK);
                            break;
                        }
                    }
                }
                break block43;
            }
            if (!fullName.equals("minecraft:items")) break block43;
            for (Object mapping : evt.getAllMappings()) {
                RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                if (!trueMapping.key.func_110624_b().equals("ftfragileglass")) continue;
                switch (trueMapping.key.func_110623_a()) {
                    case "ftfragileglass": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_FRAGILE_GLASS);
                        break;
                    }
                    case "ftfragilepane": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_FRAGILE_PANE);
                        break;
                    }
                    case "ftstainedfragileglass": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_WHITE_STAINED_FRAGILE_GLASS);
                        break;
                    }
                    case "ftstainedfragilepane": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_WHITE_STAINED_FRAGILE_GLASS_PANE);
                        break;
                    }
                    case "ftthinice": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_THIN_ICE);
                        break;
                    }
                    case "ftweakstone": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_WEAK_STONE);
                        break;
                    }
                    case "ftsugarcauldron": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_SUGAR_CAULDRON);
                        break;
                    }
                    case "ftsugarblock": {
                        trueMapping.remap((IForgeRegistryEntry)ITEM_SUGAR_BLOCK);
                        break;
                    }
                }
            }
        }
    }

    public static BlockDataManager getBlockDataManager() {
        return blockDataManager;
    }

    public static EntityDataManager getEntityDataManager() {
        return entityDataManager;
    }

    public static TileEntityDataManager getTileEntityDataManager() {
        return tileEntityDataManager;
    }

    public static boolean reloadDataManagers() {
        blockDataManager.clearData();
        entityDataManager.clearData();
        tileEntityDataManager.clearData();
        boolean blocksOK = blockDataManager.loadData();
        boolean entitiesOK = entityDataManager.loadData();
        boolean tilesOK = tileEntityDataManager.loadData();
        return blocksOK && entitiesOK && tilesOK;
    }

    @SubscribeEvent
    public void onBreakerConstruct(AttachCapabilitiesEvent<Entity> evt) {
        final Entity e = (Entity)evt.getObject();
        if (e.field_70170_p != null) {
            if (e.field_70170_p.field_72995_K) {
                if (e instanceof ClientPlayerEntity) {
                    MinecraftForge.EVENT_BUS.register(new Object(){
                        private PlayerEntity ep;
                        private double lastSpeedSq;
                        private final Minecraft game;
                        {
                            this.ep = (PlayerEntity)e;
                            this.game = Minecraft.func_71410_x();
                        }

                        @SubscribeEvent(priority=EventPriority.HIGHEST)
                        public void speedUpdate(TickEvent.ClientTickEvent event) {
                            if (this.ep == this.game.field_71439_g && event.phase == TickEvent.Phase.START) {
                                Vec3d motion = this.ep.func_213322_ci();
                                double speedSq = Math.max(motion.field_72450_a * motion.field_72450_a + motion.field_72448_b * motion.field_72448_b + motion.field_72449_c * motion.field_72449_c, 0.0);
                                if (Math.abs(speedSq - this.lastSpeedSq) > 0.001) {
                                    MessageBreakerMovement mbm = new MessageBreakerMovement();
                                    mbm.motionx = motion.field_72450_a;
                                    mbm.motiony = motion.field_72448_b;
                                    mbm.motionz = motion.field_72449_c;
                                    mbm.speedSq = speedSq;
                                    PacketHandler.INSTANCE.sendToServer((Object)mbm);
                                    this.lastSpeedSq = speedSq;
                                }
                                if (this.ep.field_70128_L) {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        }

                        @SubscribeEvent
                        public void killObject(ClientPlayerNetworkEvent.LoggedOutEvent event) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    });
                }
            } else if (e instanceof PlayerEntity) {
                evt.addCapability(DataReference.PLAYER_BREAK_LOCATION, new ICapabilityProvider(){
                    IPlayerBreakCapability inst = (IPlayerBreakCapability)PLAYERBREAKCAP.getDefaultInstance();

                    @Nonnull
                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                        if (capability == PLAYERBREAKCAP || capability == BREAKCAP) {
                            return LazyOptional.of(() -> this.inst);
                        }
                        return LazyOptional.empty();
                    }
                });
            } else {
                entityDataManager.addCapabilityIfPossible(e, evt);
            }
        }
    }

    @SubscribeEvent
    public void initPlayerBreakerCap(EntityJoinWorldEvent ejwe) {
        Entity e = ejwe.getEntity();
        e.getCapability(PLAYERBREAKCAP).ifPresent(pbc -> pbc.init(e));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void loadSystem(WorldEvent.Load event) {
        World w = (World)event.getWorld();
        if (!w.field_72995_K) {
            BreakSystem.forWorld(w).init(w);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void stopSystem(WorldEvent.Unload event) {
        World w = (World)event.getWorld();
        if (!w.field_72995_K) {
            BreakSystem.forWorld(w).end(w);
        }
    }

    public static void error(String message) {
        LOGGER.error(message);
    }

    public static void warn(String message) {
        LOGGER.error(message);
    }

    public static ITextComponent setReloadStatus(boolean ok) {
        STATUS = ok ? SUCCESS_MESSAGE : FAILURE_MESSAGE;
        return STATUS;
    }

    @SubscribeEvent
    public void handleServerAboutToStart(FMLServerAboutToStartEvent event) {
        MinecraftServer ms = event.getServer();
        blockDataManager.setupDirsAndFiles(ms);
        entityDataManager.setupDirsAndFiles(ms);
        tileEntityDataManager.setupDirsAndFiles(ms);
        ms.func_195570_aG().func_219534_a((IFutureReloadListener)new ReloadListener<Map<ResourceLocation, Tag.Builder<EntityType<?>>>>(){

            protected Map<ResourceLocation, Tag.Builder<EntityType<?>>> prepare(IResourceManager iResourceManager, IProfiler iProfiler) {
                return null;
            }

            protected void apply(Map<ResourceLocation, Tag.Builder<EntityType<?>>> resourceLocationBuilderMap, IResourceManager iResourceManager, IProfiler iProfiler) {
                FragileGlassBase.setReloadStatus(FragileGlassBase.reloadDataManagers());
                if (cachedCommandSource != null) {
                    cachedCommandSource.func_197030_a(STATUS, true);
                    cachedCommandSource = null;
                }
            }
        });
    }

    @SubscribeEvent
    public void registerCommands(FMLServerStartingEvent event) {
        CommandsBase.registerCommands((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity pe = event.getPlayer();
        if (pe.func_211513_k(2) || pe.field_70170_p.func_73046_m().func_71264_H()) {
            if (STATUS == FAILURE_MESSAGE) {
                pe.func_146105_b(STATUS, false);
            } else if (((Boolean)WorldgenConfig.SHOW_SUCCESS_MESSAGE.get()).booleanValue()) {
                pe.func_146105_b(STATUS, false);
            }
        }
    }

    @SubscribeEvent
    public void onReloadCommand(CommandEvent ce) {
        if (ce.getParseResults().getReader().getString().equals("/reload")) {
            cachedCommandSource = (CommandSource)ce.getParseResults().getContext().getSource();
        }
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        BREAKCAP = null;
        PLAYERBREAKCAP = null;
        FRAGILECAP = null;
        SUCCESS_MESSAGE = new StringTextComponent("[FRAGILE GLASS] Data reloaded without errors!").func_211708_a(TextFormatting.GREEN);
        FAILURE_MESSAGE = new StringTextComponent("[FRAGILE GLASS] Errors found in config files; please check config folder for more information.").func_211708_a(TextFormatting.RED);
        cachedCommandSource = null;
    }
}

