/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.command;

import com.fredtargaryen.fragileglass.command.CommandsBase;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.DataManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ExportAllCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(CommandsBase.baseCommand("exportall", (Command<CommandSource>)((Command)e -> ExportAllCommand.execute((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"manager")))));
    }

    private static int execute(CommandSource source, String manager) {
        DataManager dm = CommandsBase.getDataManager(manager);
        if (dm == null) {
            return 1;
        }
        StringBuilder sb = new StringBuilder();
        if (manager.equals("blocks")) {
            dm.getKeys().forEach(state -> {
                try {
                    List fdList = (List)dm.getData(state);
                    fdList.forEach(fragilityData -> {
                        sb.append(dm.stringifyBehaviour(state, null));
                        sb.append("\n");
                    });
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing block state data for " + KeyParser.cleanBlockStateString(state.toString())), false);
                }
            });
        } else if (manager.equals("entities")) {
            dm.getKeys().forEach(type -> {
                try {
                    sb.append(dm.stringifyBehaviour(type, null));
                    sb.append("\n");
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing entity data for " + ((EntityType)type).getRegistryName()), false);
                }
            });
        } else {
            dm.getKeys().forEach(type -> {
                try {
                    List fdList = (List)dm.getData(type);
                    fdList.forEach(fragilityData -> {
                        sb.append(dm.stringifyBehaviour(type, null));
                        sb.append("\n");
                    });
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing tile entity data for " + ((TileEntityType)type).getRegistryName()), false);
                }
            });
        }
        try {
            dm.export(sb.toString());
            source.func_197030_a((ITextComponent)new StringTextComponent("File exported successfully!"), true);
            return 0;
        }
        catch (IOException ioe) {
            source.func_197030_a((ITextComponent)new StringTextComponent("File failed to export."), true);
            return 1;
        }
    }
}

