/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.configloader;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.BreakerData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.EntityDataManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.entity.EntityType;

public class EntityConfigLoader
extends ConfigLoader {
    private EntityDataManager manager;
    private HashMap<EntityType, BreakerData> entities;

    public EntityConfigLoader(EntityDataManager manager, HashMap<EntityType, BreakerData> entities) {
        this.manager = manager;
        this.entities = entities;
    }

    @Override
    protected void parseLine() throws ConfigLoader.ConfigLoadException {
        String[] values = this.line.split(" ");
        if (values.length < 3) {
            throw new ConfigLoader.ConfigLoadException("There must be at least 3 values here.");
        }
        try {
            Collection<EntityType<?>> entityTypes = KeyParser.getAllEntityTypesForString(values[0]);
            for (EntityType<?> et : entityTypes) {
                double minSpeedSquared = Double.parseDouble(values[1]);
                minSpeedSquared = Math.max(minSpeedSquared * minSpeedSquared, 0.0);
                double maxSpeedSquared = Double.parseDouble(values[2]);
                if (minSpeedSquared > (maxSpeedSquared = Math.min(maxSpeedSquared * maxSpeedSquared, 34.72273476))) {
                    double temp = minSpeedSquared;
                    minSpeedSquared = maxSpeedSquared;
                    maxSpeedSquared = temp;
                }
                this.entities.put(et, new BreakerData(minSpeedSquared, maxSpeedSquared, Arrays.copyOfRange(values, 3, values.length)));
            }
        }
        catch (NumberFormatException nfe) {
            throw new ConfigLoader.ConfigLoadException("One of your speed values can't be read as a decimal number.");
        }
        catch (Exception e) {
            throw new ConfigLoader.ConfigLoadException(e.getMessage());
        }
    }
}

