/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.configloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class KeyParser {
    private static final String RES_LOC_REGEX = "[a-z]+:[a-z|_]+";
    private static final String VARIANT_REGEX = "[a-z]+=([0-9]+|[a-z|_]+)";
    private static final String VARIANTS_REGEX = "([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))";
    private static final String BLOCK_STATES_REGEX = "[a-z]+:[a-z|_]+\\[([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))\\]";
    private static final String TAGS_RES_LOC_REGEX = "#[a-z]+:[a-z|_]+";
    private static final String TAGS_BLOCK_STATES_REGEX = "#[a-z]+:[a-z|_]+\\[([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))\\]";
    private static final String OLD_WITHPROPS_REGEX = "\\-\\[([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))\\]";

    public static String cleanBlockStateString(String blockStateString) {
        String[] parts = blockStateString.substring(6).split("}");
        if (parts.length == 1) {
            return parts[0];
        }
        return parts[0] + parts[1];
    }

    public static List<BlockState> getAllBlockStatesForString(String states) {
        ArrayList<Block> blocks;
        HashMap<String, String> description = KeyParser.getDescriptionFromString(states);
        if (description == null) {
            return new ArrayList<BlockState>();
        }
        ArrayList<BlockState> allStates = new ArrayList<BlockState>();
        String tag = description.get("tag");
        if (tag == null) {
            Block block = KeyParser.getBlockFromString(description.get("block"));
            blocks = new ArrayList<Block>();
            if (block == Blocks.field_150350_a) {
                String blockString = description.get("block");
                if (blockString.equals("minecraft:air") || blockString.equals("-")) {
                    blocks.add(block);
                }
            } else {
                blocks.add(block);
            }
        } else {
            blocks = BlockTags.func_199896_a().func_199915_b(new ResourceLocation(tag)).func_199885_a();
        }
        String propsString = description.get("properties");
        for (Block block : blocks) {
            Object filteredStates = block.func_176194_O().func_177619_a();
            if (propsString != null) {
                HashMap<IProperty<?>, Object> specifiedProperties = KeyParser.parseStringPropertyMap(block.func_176223_P(), KeyParser.getStringPropertyMapFrom(propsString));
                for (IProperty<?> iprop : specifiedProperties.keySet()) {
                    filteredStates = filteredStates.stream().filter(state -> state.func_177229_b(iprop) == specifiedProperties.get(iprop)).collect(Collectors.toList());
                }
            }
            allStates.addAll((Collection<BlockState>)filteredStates);
        }
        return allStates;
    }

    public static Block getBlockFromString(String state) {
        if (state == null) {
            return Blocks.field_150350_a;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(state));
    }

    public static HashMap<String, String> getDescriptionFromString(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (string.equals("-")) {
            map.put("tag", null);
            map.put("block", "-");
            map.put("properties", null);
        } else if (string.matches(OLD_WITHPROPS_REGEX)) {
            String[] splitString = string.split("\\[");
            map.put("tag", null);
            map.put("block", "-");
            map.put("properties", splitString[1].substring(0, splitString[1].length() - 1));
        } else if (string.matches(RES_LOC_REGEX)) {
            map.put("tag", null);
            map.put("block", string);
            map.put("properties", null);
        } else if (string.matches(TAGS_RES_LOC_REGEX)) {
            map.put("tag", string.substring(1));
            map.put("block", null);
            map.put("properties", null);
        } else if (string.matches(BLOCK_STATES_REGEX)) {
            String[] splitString = string.split("\\[");
            map.put("tag", null);
            map.put("block", splitString[0]);
            map.put("properties", splitString[1].substring(0, splitString[1].length() - 1));
        } else if (string.matches(TAGS_BLOCK_STATES_REGEX)) {
            String[] splitString = string.split("\\[");
            map.put("tag", splitString[0].substring(1));
            map.put("block", null);
            map.put("properties", splitString[1].substring(0, splitString[1].length() - 1));
        } else {
            return null;
        }
        return map;
    }

    public static HashMap<String, String> getStringPropertyMapFrom(BlockState state) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (IProperty prop : state.func_206869_a()) {
            map.put(prop.func_177701_a(), state.func_177229_b(prop).toString());
        }
        return map;
    }

    public static HashMap<String, String> getStringPropertyMapFrom(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (string != null) {
            String[] variantInfo;
            for (String variant : variantInfo = string.split(",")) {
                String[] info = variant.split("=");
                map.put(info[0], info[1]);
            }
        }
        return map;
    }

    public static HashMap<IProperty<?>, Object> parseStringPropertyMap(BlockState reference, HashMap<String, String> map) {
        if (map == null) {
            map = new HashMap();
        }
        HashMap properties = new HashMap();
        Collection existingProps = reference.func_206869_a();
        for (IProperty prop : existingProps) {
            String propName = prop.func_177701_a();
            if (!map.containsKey(propName)) continue;
            String value = map.get(propName);
            if (prop instanceof BooleanProperty) {
                BooleanProperty bp = (BooleanProperty)prop;
                bp.func_185929_b(value).ifPresent(b -> properties.put((IProperty<?>)bp, b));
                continue;
            }
            if (prop instanceof IntegerProperty) {
                IntegerProperty ip = (IntegerProperty)prop;
                ip.func_185929_b(value).ifPresent(i -> properties.put((IProperty<?>)ip, i));
                continue;
            }
            if (!(prop instanceof EnumProperty)) continue;
            EnumProperty ep = (EnumProperty)prop;
            ep.func_185929_b(value).ifPresent(e -> properties.put((IProperty<?>)ep, e));
        }
        return properties;
    }

    public static Collection<EntityType<?>> getAllEntityTypesForString(String value) throws Exception {
        ArrayList<EntityType<?>> entityTypes = new ArrayList();
        if (value.charAt(0) == '#') {
            entityTypes = EntityTypeTags.func_219762_a().func_199915_b(new ResourceLocation(value.substring(1))).func_199885_a();
        } else {
            entityTypes = new ArrayList();
            EntityType entry = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(value));
            if (entry == null) {
                throw new Exception("There is no entity type with the resource location " + value + ".");
            }
            entityTypes.add(entry);
        }
        return entityTypes;
    }

    public static TileEntityType getTileEntityTypeForString(String value) {
        return (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(value));
    }
}

