/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ChangeData
extends FragilityData {
    private BlockState newBlockState;

    public ChangeData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.CHANGE;
    }

    @Override
    public void parseExtraData(@Nullable BlockState oldState, ConfigLoader cl, String[] extraData) throws FragilityData.FragilityDataParseException {
        this.lengthCheck(extraData, 1);
        try {
            this.newBlockState = oldState == null ? cl.getSingleBlockStateFromString(extraData[0]) : cl.getNewStateFromOldAndString(oldState, extraData[0]);
        }
        catch (ConfigLoader.ConfigLoadException cle) {
            throw new FragilityData.FragilityDataParseException(this, cle.shortMessage);
        }
    }

    @Override
    public void onCrash(World world, BlockState state, @Nullable TileEntity te, BlockPos pos, @Nullable Entity crasher, double speedSq) {
        if (speedSq > this.breakSpeedSq) {
            world.func_175656_a(pos, this.newBlockState);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " ");
        sb.append(KeyParser.cleanBlockStateString(this.newBlockState.toString()));
        return sb.toString();
    }
}

