/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandData
extends FragilityData
implements ICommandSource {
    private boolean executeFromCrasherPos;
    private String command;

    public CommandData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.COMMAND;
    }

    @Override
    public void parseExtraData(@Nullable BlockState state, ConfigLoader cl, String[] extraData) throws FragilityData.FragilityDataParseException {
        if (extraData.length == 0) {
            throw new FragilityData.FragilityDataParseException(this, "No position given for command behaviour!");
        }
        if (extraData.length == 1) {
            throw new FragilityData.FragilityDataParseException(this, "No command given for command behaviour!");
        }
        if (extraData[1].charAt(0) != '/') {
            throw new FragilityData.FragilityDataParseException(this, "The first word of the command must begin with a /");
        }
        if (extraData[0].toLowerCase().equals("block")) {
            this.executeFromCrasherPos = false;
        } else if (extraData[0].toLowerCase().equals("entity")) {
            this.executeFromCrasherPos = true;
        } else {
            throw new FragilityData.FragilityDataParseException(this, "The first value (" + extraData[0] + ") should be block if you want to execute the command relative to the block, or entity if relative to the entity that crashed.");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < extraData.length - 1; ++i) {
            sb.append(extraData[i]);
            sb.append(" ");
        }
        sb.append(extraData[extraData.length - 1]);
        this.command = sb.toString();
    }

    @Override
    public void onCrash(World world, BlockState state, @Nullable TileEntity te, BlockPos pos, @Nullable Entity crasher, double speedSq) {
        CommandSource cs = new CommandSource((ICommandSource)this, this.executeFromCrasherPos ? crasher.func_213303_ch() : new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), this.executeFromCrasherPos ? crasher.func_189653_aC() : Vec2f.field_189974_a, (ServerWorld)world, 2, "", (ITextComponent)new StringTextComponent(""), world.func_73046_m(), crasher);
        world.func_73046_m().func_195571_aL().func_197059_a(cs, this.command);
    }

    @Override
    public String toString() {
        return super.toString() + " " + (this.executeFromCrasherPos ? "entity" : "block") + " " + this.command;
    }

    @Override
    public boolean canBeQueued() {
        return !this.executeFromCrasherPos;
    }

    public void func_145747_a(ITextComponent iTextComponent) {
    }

    public boolean func_195039_a() {
        return false;
    }

    public boolean func_195040_b() {
        return false;
    }

    public boolean func_195041_r_() {
        return false;
    }
}

