/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FragilityData {
    protected double breakSpeedSq;

    public FragilityData(double breakSpeed) {
        this.breakSpeedSq = breakSpeed * breakSpeed;
    }

    public abstract FragileBehaviour getBehaviour();

    public static FragileBehaviour parseBehaviour(String behaviour) {
        return FragileBehaviour.valueOf(behaviour.toUpperCase());
    }

    public final double getBreakSpeedSq() {
        return this.breakSpeedSq;
    }

    public abstract void parseExtraData(@Nullable BlockState var1, ConfigLoader var2, String ... var3) throws FragilityDataParseException;

    public abstract void onCrash(World var1, BlockState var2, @Nullable TileEntity var3, BlockPos var4, @Nullable Entity var5, double var6);

    protected final void lengthCheck(String[] extraData, int length) throws FragilityDataParseException {
        if (extraData.length != length) {
            throw new FragilityDataParseException("This behaviour must have " + length + " extra parameters after the first 3.");
        }
    }

    public String toString() {
        return this.getBehaviour().toString() + " " + Math.sqrt(this.breakSpeedSq);
    }

    public boolean canBeQueued() {
        return true;
    }

    public class FragilityDataParseException
    extends Exception {
        public FragilityDataParseException(String message) {
            super(message);
        }
    }

    public static enum FragileBehaviour {
        BREAK,
        CHANGE,
        COMMAND,
        DAMAGE,
        EXPLODE,
        FALL,
        MOD,
        UPDATE,
        WAIT;

    }
}

